/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import com.floragunn.searchguard.lpg.Strings;
import com.floragunn.searchguard.lpg.UserDataPacket;
import java.io.IOException;

public class UserIDPacket
extends ContainedPacket
implements UserDataPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    public UserIDPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(13, newPacketFormat);
        this.idData = in.readAll();
    }

    public UserIDPacket(String id) {
        super(13);
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public UserIDPacket(byte[] rawID) {
        super(13);
        this.idData = Arrays.clone(rawID);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object o) {
        if (o instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)o).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.hasNewPacketFormat(), 13, this.idData);
    }
}

