/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLUtil;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregateTrustManager
implements X509TrustManager {
    @NotNull
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private final boolean requireAllAccepted;
    @NotNull
    private final List<X509TrustManager> trustManagers;

    public AggregateTrustManager(boolean requireAllAccepted, X509TrustManager ... trustManagers) {
        this(requireAllAccepted, StaticUtils.toList(trustManagers));
    }

    public AggregateTrustManager(boolean requireAllAccepted, @NotNull Collection<X509TrustManager> trustManagers) {
        Validator.ensureNotNull(trustManagers);
        Validator.ensureFalse(trustManagers.isEmpty(), "The set of associated trust managers must not be empty.");
        this.requireAllAccepted = requireAllAccepted;
        this.trustManagers = Collections.unmodifiableList(new ArrayList<X509TrustManager>(trustManagers));
    }

    public boolean requireAllAccepted() {
        return this.requireAllAccepted;
    }

    @NotNull
    public List<X509TrustManager> getAssociatedTrustManagers() {
        return this.trustManagers;
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        ArrayList<String> exceptionMessages = null;
        for (X509TrustManager m : this.trustManagers) {
            try {
                m.checkClientTrusted(chain, authType);
                if (this.requireAllAccepted) continue;
                return;
            }
            catch (CertificateException ce) {
                Debug.debugException(ce);
                if (this.requireAllAccepted) {
                    throw ce;
                }
                if (exceptionMessages == null) {
                    exceptionMessages = new ArrayList<String>(this.trustManagers.size());
                }
                exceptionMessages.add(ce.getMessage());
            }
        }
        if (exceptionMessages != null && !exceptionMessages.isEmpty()) {
            if (exceptionMessages.size() == 1) {
                throw new CertificateException((String)exceptionMessages.get(0));
            }
            throw new CertificateException(SSLMessages.ERR_AGGREGATE_TRUST_MANAGER_NONE_TRUSTED.get(SSLUtil.certificateToString(chain[0]), StaticUtils.concatenateStrings(exceptionMessages)));
        }
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        ArrayList<String> exceptionMessages = null;
        for (X509TrustManager m : this.trustManagers) {
            try {
                m.checkServerTrusted(chain, authType);
                if (this.requireAllAccepted) continue;
                return;
            }
            catch (CertificateException ce) {
                Debug.debugException(ce);
                if (this.requireAllAccepted) {
                    throw ce;
                }
                if (exceptionMessages == null) {
                    exceptionMessages = new ArrayList<String>(this.trustManagers.size());
                }
                exceptionMessages.add(ce.getMessage());
            }
        }
        if (exceptionMessages != null && !exceptionMessages.isEmpty()) {
            if (exceptionMessages.size() == 1) {
                throw new CertificateException((String)exceptionMessages.get(0));
            }
            throw new CertificateException(SSLMessages.ERR_AGGREGATE_TRUST_MANAGER_NONE_TRUSTED.get(SSLUtil.certificateToString(chain[0]), StaticUtils.concatenateStrings(exceptionMessages)));
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

