/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.text;

import com.floragunn.codova.config.text.PatternImpl;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class SimplePatternImpl
extends PatternImpl {
    private final String source;
    private final String[] tokens;
    private final String prefix;

    SimplePatternImpl(String pattern) {
        this.source = pattern;
        this.tokens = SimplePatternImpl.splitOnTokens(pattern);
        this.prefix = !this.tokens[0].equals("*") && !this.tokens[0].equals("?") ? this.tokens[0] : null;
    }

    @Override
    public boolean matches(String string) {
        return this.matches(string, 0, 0);
    }

    @Override
    boolean matchesSkipPrefix(String string) {
        if (this.prefix != null) {
            return this.matches(string, this.prefix.length(), 1);
        }
        return this.matches(string);
    }

    private boolean matches(String string, int startTextIdx, int startWcsIdx) {
        if (string == null) {
            return false;
        }
        String[] wcs = this.tokens;
        boolean anyChars = false;
        int textIdx = startTextIdx;
        int wcsIdx = startWcsIdx;
        ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>(wcs.length);
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > string.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = string.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = string.indexOf(wcs[wcsIdx], textIdx)) == -1) break;
                        int repeat = string.indexOf(wcs[wcsIdx], textIdx + 1);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!string.regionMatches(false, textIdx, wcs[wcsIdx], 0, wcs[wcsIdx].length())) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != string.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePatternImpl)) {
            return false;
        }
        return ((SimplePatternImpl)obj).source.equals(this.source);
    }

    public String toString() {
        return this.source;
    }

    @Override
    public ImmutableSet<String> getConstants() {
        return ImmutableSet.empty();
    }

    @Override
    public ImmutableSet<String> getPatterns() {
        return ImmutableSet.of((Object)this.source);
    }

    @Override
    public Object toBasicObject() {
        return ImmutableList.of((Object)this.source);
    }

    private static String[] splitOnTokens(String text) {
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    String getPrefix() {
        return this.prefix;
    }
}

