/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.concurrent.NamedRunnable;

public class AsyncOperationHelper {
    public static CompletableFuture<Void> executeAsync(@NotNull String processName, @NotNull Runnable operation) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return CompletableFuture.runAsync(new NamedRunnable(processName, operation), executorService).thenRun(executorService::shutdown);
    }

    public static CompletableFuture<Void> executeAsync(@NotNull ExecutorService executorService, @NotNull String processName, @NotNull Runnable operation) {
        Preconditions.assumeTrue(!executorService.isShutdown(), "cannot send async email, executor service is already shut down!");
        return CompletableFuture.runAsync(new NamedRunnable(processName, operation), executorService);
    }

    @Generated
    private AsyncOperationHelper() {
    }
}

