/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auditlog;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class AuditLogSslExceptionHandler
implements SslExceptionHandler {
    private final AuditLog auditLog;

    public AuditLogSslExceptionHandler(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void logError(Throwable t, RestRequest request, int type) {
        switch (type) {
            case 0: {
                this.auditLog.logSSLException(request, t);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request);
                break;
            }
        }
    }

    public void logError(Throwable t, boolean isRest) {
        if (isRest) {
            this.auditLog.logSSLException(null, t);
        } else {
            this.auditLog.logSSLException(null, t, null, null);
        }
    }

    public void logError(Throwable t, TransportRequest request, String action, Task task, int type) {
        switch (type) {
            case 0: {
                if (t instanceof ElasticsearchException) {
                    this.auditLog.logMissingPrivileges(action, request, task);
                    break;
                }
                this.auditLog.logSSLException(request, t, action, task);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request, action, task);
                break;
            }
        }
    }
}

