/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.indices;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;

public class SearchGuardDirectoryReaderWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    private final ThreadContext threadContext;
    private final Index index;
    private final AdminDNs adminDns;
    private final ImmutableList<CheckedFunction<DirectoryReader, DirectoryReader, IOException>> moreWrappersForNormalOperations;
    private final ImmutableList<CheckedFunction<DirectoryReader, DirectoryReader, IOException>> moreWrappersForAllOperations;

    public SearchGuardDirectoryReaderWrapper(IndexService indexService, AdminDNs adminDNs, ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> moreWrappersForNormalOperations, ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> moreWrappersForAllOperations) {
        this.index = indexService.index();
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.adminDns = adminDNs;
        this.moreWrappersForNormalOperations = SearchGuardDirectoryReaderWrapper.createWrappers(indexService, moreWrappersForNormalOperations);
        this.moreWrappersForAllOperations = SearchGuardDirectoryReaderWrapper.createWrappers(indexService, moreWrappersForAllOperations);
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        if (this.isAdminAuthenticatedOrInternalRequest()) {
            for (CheckedFunction nextWrapper : this.moreWrappersForAllOperations) {
                reader = (DirectoryReader)nextWrapper.apply((Object)reader);
            }
            return reader;
        }
        if (this.isSearchGuardIndexRequest()) {
            return new EmptyFilterLeafReader.EmptyDirectoryReader(reader);
        }
        for (CheckedFunction nextWrapper : this.moreWrappersForNormalOperations) {
            reader = (DirectoryReader)nextWrapper.apply((Object)reader);
        }
        for (CheckedFunction nextWrapper : this.moreWrappersForAllOperations) {
            reader = (DirectoryReader)nextWrapper.apply((Object)reader);
        }
        return reader;
    }

    protected final boolean isAdminAuthenticatedOrInternalRequest() {
        User user = (User)this.threadContext.getTransient("_sg_user");
        if (user != null && this.adminDns.isAdmin(user)) {
            return true;
        }
        return "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
    }

    protected final boolean isSearchGuardIndexRequest() {
        return SearchGuardPlugin.getProtectedIndices().isProtected(this.index.getName());
    }

    private static ImmutableList<CheckedFunction<DirectoryReader, DirectoryReader, IOException>> createWrappers(IndexService indexService, ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> moreWrappers) {
        return moreWrappers.map(v -> (CheckedFunction)v.apply(indexService));
    }

    static class EmptyFilterLeafReader
    extends FilterLeafReader {
        final Bits liveDocs;

        public EmptyFilterLeafReader(LeafReader in) {
            super(in);
            this.liveDocs = new Bits.MatchNoBits(in.maxDoc());
            assert (this.maxDoc() == 0 || this.hasDeletions());
        }

        public Bits getLiveDocs() {
            return this.liveDocs;
        }

        public int numDocs() {
            return 0;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        static class EmptyDirectoryReader
        extends FilterDirectoryReader {
            public EmptyDirectoryReader(DirectoryReader in) throws IOException {
                super(in, (FilterDirectoryReader.SubReaderWrapper)new EmptySubReaderWrapper());
            }

            protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
                return new EmptyDirectoryReader(in);
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return this.in.getReaderCacheHelper();
            }
        }

        private static class EmptySubReaderWrapper
        extends FilterDirectoryReader.SubReaderWrapper {
            private EmptySubReaderWrapper() {
            }

            public LeafReader wrap(LeafReader reader) {
                return new EmptyFilterLeafReader(reader);
            }
        }
    }
}

