/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.delete;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.accounts.Account;
import com.floragunn.signals.accounts.NoSuchAccountException;
import com.floragunn.signals.actions.account.config_update.DestinationConfigUpdateAction;
import com.floragunn.signals.actions.account.delete.DeleteAccountRequest;
import com.floragunn.signals.actions.account.delete.DeleteAccountResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAccountAction
extends HandledTransportAction<DeleteAccountRequest, DeleteAccountResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportDeleteAccountAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:account/delete", transportService, actionFilters, DeleteAccountRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, DeleteAccountRequest request, final ActionListener<DeleteAccountResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                listener.onFailure(new Exception("Request did not contain user"));
                return;
            }
            final Account account = this.signals.getAccountRegistry().lookupAccount(request.getAccountId(), request.getAccountType());
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            Map originalResponseHeaders = threadContext.getResponseHeaders();
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                account.isInUse(this.client, this.signals.getSignalsSettings(), new ActionListener<Boolean>(){

                    public void onResponse(Boolean response) {
                        if (response.booleanValue()) {
                            listener.onResponse((Object)new DeleteAccountResponse(account.getScopedId(), -1L, DeleteAccountResponse.Result.IN_USE, RestStatus.CONFLICT, "The account is still in use"));
                        } else {
                            ((DeleteRequestBuilder)TransportDeleteAccountAction.this.client.prepareDelete().setIndex(TransportDeleteAccountAction.this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getAccounts())).setId(account.getScopedId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute((ActionListener)new ActionListener<DeleteResponse>(){

                                public void onResponse(DeleteResponse response) {
                                    if (response.getResult() == DocWriteResponse.Result.DELETED) {
                                        DestinationConfigUpdateAction.send(TransportDeleteAccountAction.this.client);
                                        listener.onResponse((Object)new DeleteAccountResponse(account.getScopedId(), response.getVersion(), DeleteAccountResponse.Result.DELETED, response.status(), null));
                                    } else {
                                        listener.onResponse((Object)new DeleteAccountResponse(account.getScopedId(), response.getVersion(), DeleteAccountResponse.Result.NOT_FOUND, response.status(), null));
                                    }
                                }

                                public void onFailure(Exception e) {
                                    listener.onFailure(e);
                                }
                            });
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (NoSuchAccountException e) {
            listener.onResponse((Object)new DeleteAccountResponse(request.getAccountId(), -1L, DeleteAccountResponse.Result.NOT_FOUND, RestStatus.NOT_FOUND, e.getMessage()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

