/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.execution;

import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.checks.Check;
import java.util.HashSet;
import java.util.Set;

public class GotoCheckSelector {
    private final Watch watch;
    private final String goTo;
    private final boolean skipAllChecks;
    private final Set<Check> skipChecks;

    public GotoCheckSelector(Watch watch, String goTo) {
        this.watch = watch;
        this.goTo = goTo;
        if (goTo == null) {
            this.skipAllChecks = false;
            this.skipChecks = null;
        } else if ("_actions".equalsIgnoreCase(goTo)) {
            this.skipAllChecks = true;
            this.skipChecks = null;
        } else {
            this.skipAllChecks = false;
            this.skipChecks = this.findChecksBefore(goTo);
        }
    }

    boolean isSelected(Check check) {
        if (this.goTo == null) {
            return true;
        }
        if (this.skipAllChecks) {
            return false;
        }
        if (this.skipChecks != null) {
            return !this.skipChecks.contains(check);
        }
        return true;
    }

    private Set<Check> findChecksBefore(String selectedCheck) {
        HashSet<Check> result = new HashSet<Check>();
        for (Check check : this.watch.getChecks()) {
            if (selectedCheck.equalsIgnoreCase(check.getName())) {
                return result;
            }
            result.add(check);
        }
        throw new IllegalArgumentException("No such check: " + selectedCheck);
    }

    public String toString() {
        return "GotoCheckSelector [goTo=" + this.goTo + "]";
    }
}

