/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.patch;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonPathPatch
implements DocPatch {
    public static final String MEDIA_TYPE = "application/x-json-path-patch+json";
    private List<Operation> operations;

    public JsonPathPatch(Operation ... operations) {
        this.operations = Arrays.asList(operations);
    }

    JsonPathPatch(DocNode source) throws ConfigValidationException {
        if (source.isList()) {
            ValidationErrors validationErrors = new ValidationErrors();
            int i = 0;
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (DocNode element : source.toListOfNodes()) {
                try {
                    operations.add(new Operation(element));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(String.valueOf(i), e);
                }
                ++i;
            }
            validationErrors.throwExceptionForPresentErrors();
            this.operations = operations;
        } else {
            this.operations = ImmutableList.of((Object)new Operation(source));
        }
    }

    @Override
    public Object toBasicObject() {
        return this.operations;
    }

    @Override
    public DocNode apply(DocNode targetDocument) {
        Object document = JsonPathPatch.createMutableCopy(targetDocument.toBasicObject());
        for (Operation operation : this.operations) {
            document = operation.apply(document);
        }
        return DocNode.wrap(document);
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }

    private static Object createMutableCopy(Object object) {
        if (object instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(String.valueOf(entry.getKey()), JsonPathPatch.createMutableCopy(entry.getValue()));
            }
            return result;
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>(((Collection)object).size());
            for (Object element : (Collection)object) {
                result.add(JsonPathPatch.createMutableCopy(element));
            }
            return result;
        }
        return object;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonPathPatch)) {
            return false;
        }
        JsonPathPatch other = (JsonPathPatch)obj;
        return !(this.operations == null ? other.operations != null : !this.operations.equals(other.operations));
    }

    public static class Operation
    implements Document<Operation> {
        private final JsonPath jsonPath;
        private final Object set;

        public Operation(JsonPath jsonPath, Object set) {
            this.jsonPath = jsonPath;
            this.set = set;
        }

        Operation(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            this.jsonPath = vNode.get("path").required().asJsonPath();
            this.set = vNode.get("set").required().asAnything();
            validationErrors.throwExceptionForPresentErrors();
        }

        @Override
        public Object toBasicObject() {
            return ImmutableMap.of((Object)"path", (Object)this.jsonPath.getPath(), (Object)"set", (Object)this.set);
        }

        Object apply(Object document) {
            return this.jsonPath.set(document, this.set, BasicJsonPathDefaultConfiguration.defaultConfiguration());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jsonPath == null ? 0 : this.jsonPath.getPath().hashCode());
            result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Operation)) {
                return false;
            }
            Operation other = (Operation)obj;
            if (this.jsonPath == null ? other.jsonPath != null : !this.jsonPath.getPath().equals(other.jsonPath.getPath())) {
                return false;
            }
            return !(this.set == null ? other.set != null : !this.set.equals(other.set));
        }
    }
}

