/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation;

import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.collect.ImmutableMap;

public class ValidationResult<T>
implements Document<ValidationResult<T>> {
    private final T parsedObject;
    private final boolean hasResult;
    private final ValidationErrors validationErrors;
    private static ValidationResult<?> EMPTY = new ValidationResult<Object>(null);

    public ValidationResult(T parsedObject) {
        this.parsedObject = parsedObject;
        this.hasResult = true;
        this.validationErrors = null;
    }

    public ValidationResult(ValidationErrors validationErrors) {
        this.parsedObject = null;
        this.hasResult = false;
        this.validationErrors = validationErrors;
    }

    public ValidationResult(ValidationError validationError) {
        this.parsedObject = null;
        this.hasResult = false;
        this.validationErrors = new ValidationErrors(validationError);
    }

    public ValidationResult(T parsedObject, ValidationErrors validationErrors) {
        this.parsedObject = parsedObject;
        this.hasResult = true;
        this.validationErrors = validationErrors;
    }

    public ValidationResult(T parsedObject, ValidationError validationError) {
        this.parsedObject = parsedObject;
        this.hasResult = true;
        this.validationErrors = new ValidationErrors(validationError);
    }

    public T get() throws ConfigValidationException {
        this.throwExceptionForPresentErrors();
        return this.parsedObject;
    }

    public T peek() {
        return this.parsedObject;
    }

    public T partial() throws ConfigValidationException {
        if (this.hasResult) {
            return this.parsedObject;
        }
        this.throwExceptionForPresentErrors();
        throw new IllegalStateException("parsedObject is null");
    }

    public void throwExceptionForPresentErrors() throws ConfigValidationException {
        if (this.validationErrors != null) {
            this.validationErrors.throwExceptionForPresentErrors();
        }
    }

    public ValidationErrors getValidationErrors() {
        if (this.validationErrors != null) {
            return this.validationErrors;
        }
        return new ValidationErrors();
    }

    public boolean hasErrors() {
        if (this.validationErrors != null) {
            return this.validationErrors.hasErrors();
        }
        return false;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public boolean hasFullResult() {
        return !this.hasErrors();
    }

    static <T> ValidationResult<T> empty() {
        return EMPTY;
    }

    @Override
    public Object toBasicObject() {
        if (this.hasResult) {
            if (this.validationErrors != null && this.validationErrors.hasErrors()) {
                return ImmutableMap.of((Object)"document", this.parsedObject, (Object)"validation_errors", (Object)this.validationErrors);
            }
            return ImmutableMap.of((Object)"document", this.parsedObject);
        }
        return ImmutableMap.of((Object)"validation_errors", (Object)this.validationErrors);
    }
}

