/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableListImpl;
import com.floragunn.fluent.collections.UnmodifiableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;

public interface ImmutableList<E>
extends UnmodifiableList<E> {
    public static <E> ImmutableList<E> empty() {
        return ImmutableListImpl.empty();
    }

    public static <E> ImmutableList<E> of(E e) {
        return new ImmutableListImpl.OneElementList<E>(e);
    }

    public static <E> ImmutableList<E> of(E e1, E e2) {
        return new ImmutableListImpl.TwoElementList<E>(e1, e2);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E ... more) {
        return ImmutableListImpl.of(e1, e2, e3, more);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> ofArray(E ... more) {
        return ImmutableListImpl.ofArray(more);
    }

    public static <E> ImmutableList<E> of(Collection<? extends E> collection) {
        return ImmutableListImpl.of(collection);
    }

    public static <E> ImmutableList<E> ofNonNull(E e) {
        return ImmutableListImpl.ofNonNull(e);
    }

    public static <E> ImmutableList<E> ofNonNull(E e1, E e2) {
        return ImmutableListImpl.ofNonNull(e1, e2);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> ofNonNull(E e1, E e2, E ... more) {
        return ImmutableListImpl.ofNonNull(e1, e2, more);
    }

    public static <E> ImmutableList<E> concat(Collection<? extends E> c1, Collection<? extends E> c2) {
        return ImmutableListImpl.concat(c1, c2);
    }

    public static <E> ImmutableList<E> concat(Collection<? extends E> c1, Collection<? extends E> c2, Collection<? extends E> c3) {
        return ImmutableListImpl.concat(c1, c2, c3);
    }

    public static <C, E> ImmutableList<E> map(Collection<C> collection, Function<C, E> mappingFunction) {
        return ImmutableListImpl.map(collection, mappingFunction);
    }

    public static <E> Collector<E, ?, ImmutableList<E>> collector() {
        return ImmutableListImpl.collector();
    }

    public ImmutableList<E> with(E var1);

    public ImmutableList<E> with(Collection<E> var1);

    public ImmutableList<E> with(Optional<E> var1);

    public ImmutableList<E> with(E ... var1);

    public ImmutableList<E> matching(Predicate<E> var1);

    public ImmutableList<E> without(Collection<E> var1);

    public <O> ImmutableList<O> map(Function<E, O> var1);

    @Override
    public ImmutableList<E> subList(int var1, int var2);

    public boolean forAllApplies(Predicate<E> var1);

    public boolean forAnyApplies(Predicate<E> var1);

    public E only();

    public E any();

    public E first();

    public E last();

    public String toShortString();

    public static class Builder<E> {
        private ArrayList<E> list;

        public Builder() {
            this(10);
        }

        public Builder(int expectedNumberOfElements) {
            this.list = new ArrayList(expectedNumberOfElements);
        }

        public Builder(Collection<E> initialContent) {
            this.list = new ArrayList<E>(initialContent);
        }

        public Builder<E> add(E e) {
            this.list.add(e);
            return this;
        }

        public Builder<E> with(E e) {
            this.list.add(e);
            return this;
        }

        public Builder<E> add(Optional<E> optional) {
            if (optional.isPresent()) {
                this.list.add(optional.get());
            }
            return this;
        }

        public boolean addAll(Collection<E> collection) {
            return this.list.addAll(collection);
        }

        public Builder<E> with(Optional<E> optional) {
            if (optional.isPresent()) {
                this.list.add(optional.get());
            }
            return this;
        }

        public Builder<E> with(Collection<E> collection) {
            this.list.addAll(collection);
            return this;
        }

        public ImmutableList<E> build() {
            return ImmutableList.of(this.list);
        }

        public ImmutableList<E> build(Comparator<E> sortedBy) {
            this.list.sort(sortedBy);
            return ImmutableList.of(this.list);
        }
    }
}

