/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.asn1;

import com.floragunn.searchguard.lpg.asn1.ASN1Encodable;
import com.floragunn.searchguard.lpg.asn1.ASN1Exception;
import com.floragunn.searchguard.lpg.asn1.ASN1ExternalParser;
import com.floragunn.searchguard.lpg.asn1.ASN1ParsingException;
import com.floragunn.searchguard.lpg.asn1.ASN1Primitive;
import com.floragunn.searchguard.lpg.asn1.ASN1StreamParser;
import com.floragunn.searchguard.lpg.asn1.DLExternal;
import com.floragunn.searchguard.lpg.asn1.DLSequence;
import java.io.IOException;

public class DERExternalParser
implements ASN1ExternalParser {
    private ASN1StreamParser _parser;

    public DERExternalParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this._parser.readObject();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return DERExternalParser.parse(this._parser);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
        catch (IllegalArgumentException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
    }

    static DLExternal parse(ASN1StreamParser sp) throws IOException {
        try {
            return new DLExternal(new DLSequence(sp.readVector()));
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception(e.getMessage(), e);
        }
    }
}

