/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open.operator.bc;

import com.floragunn.searchguard.lpg.AsymmetricKeyParameter;
import com.floragunn.searchguard.lpg.Signer;
import com.floragunn.searchguard.lpg.open.PGPException;
import com.floragunn.searchguard.lpg.open.PGPPublicKey;
import com.floragunn.searchguard.lpg.open.operator.PGPContentVerifier;
import com.floragunn.searchguard.lpg.open.operator.PGPContentVerifierBuilder;
import com.floragunn.searchguard.lpg.open.operator.PGPContentVerifierBuilderProvider;
import com.floragunn.searchguard.lpg.open.operator.bc.BcImplProvider;
import com.floragunn.searchguard.lpg.open.operator.bc.BcPGPKeyConverter;
import com.floragunn.searchguard.lpg.open.operator.bc.SignerOutputStream;
import java.io.OutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    @Override
    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new BcPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public PGPContentVerifier build(final PGPPublicKey publicKey) throws PGPException {
            AsymmetricKeyParameter pubParam = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey);
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, pubParam);
            signer.init(false, pubParam);
            return new PGPContentVerifier(){

                @Override
                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                @Override
                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                @Override
                public long getKeyID() {
                    return publicKey.getKeyID();
                }

                @Override
                public boolean verify(byte[] expected) {
                    return signer.verifySignature(expected);
                }

                @Override
                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

