/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest.authenticators;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientCertAuthenticationFrontend
implements HttpAuthenticationFrontend {
    private static final Logger log = LogManager.getLogger(HttpClientCertAuthenticationFrontend.class);
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "clientcert").initialized();

    public HttpClientCertAuthenticationFrontend(DocNode settings, ConfigurationRepository.Context context) {
    }

    @Override
    public AuthCredentials extractCredentials(RequestMetaData<?> request) {
        String principal = request.getClientCertSubject();
        if (Strings.isNullOrEmpty((String)principal)) {
            log.debug("No client cert provided");
            return null;
        }
        try {
            LdapName rfc2253dn = new LdapName(principal);
            String username = principal.trim();
            return AuthCredentials.forUser(username).userMappingAttribute("clientcert", ImmutableMap.of((Object)"subject", this.dnToMap(rfc2253dn))).build();
        }
        catch (InvalidNameException e) {
            log.error("Client cert had no properly formed DN (was: {})", (Object)principal, (Object)e);
            return null;
        }
    }

    @Override
    public String getType() {
        return "clientcert";
    }

    private Map<String, ?> dnToMap(LdapName ldapName) {
        HashMap<String, List> result = new HashMap<String, List>();
        for (Rdn rdn : ldapName.getRdns()) {
            String directoryStringAttribute = rdn.getType();
            result.computeIfAbsent(directoryStringAttribute, k -> new ArrayList(1)).add(rdn.getValue());
            if (HttpClientCertAuthenticationFrontend.isLowerCaseString(directoryStringAttribute)) continue;
            result.computeIfAbsent(directoryStringAttribute.toLowerCase(), k -> new ArrayList(1)).add(rdn.getValue());
        }
        return result;
    }

    private static boolean isLowerCaseString(String string) {
        return string.toLowerCase().equals(string);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

