/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.backend.PushSessionTokenUpdateAction;
import com.floragunn.searchguard.authc.session.backend.SessionApi;
import com.floragunn.searchguard.authc.session.backend.SessionService;
import com.floragunn.searchguard.authc.session.backend.SessionServiceConfig;
import com.floragunn.searchguard.authc.session.backend.SessionServiceConfigApi;
import com.floragunn.searchguard.authc.session.backend.SessionTokenAuthenticationDomain;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.action.ActionHandlerFactory;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;

public class SessionModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(SessionModule.class);
    private SessionService sessionService;
    private SessionApi.Rest sessionRestAction = new SessionApi.Rest();
    private ConfigVarService configVarService;
    private SessionTokenAuthenticationDomain sessionTokenAuthenticationDomain;
    private final ComponentState componentState = new ComponentState(2, "authc", "session_service", SessionModule.class);

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{this.sessionRestAction, SessionServiceConfigApi.REST_API});
    }

    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return ImmutableList.of((Object)ActionHandlerFactory.actionHandler((ActionType)SessionApi.GetExtendedInfoAction.INSTANCE, SessionApi.GetExtendedInfoAction.Handler.class), (Object)ActionHandlerFactory.actionHandler((ActionType)SessionApi.CreateAction.INSTANCE, SessionApi.CreateAction.Handler.class), (Object)ActionHandlerFactory.actionHandler((ActionType)SessionApi.DeleteAction.INSTANCE, SessionApi.DeleteAction.Handler.class), (Object[])new ActionPlugin.ActionHandler[]{ActionHandlerFactory.actionHandler((ActionType)PushSessionTokenUpdateAction.INSTANCE, PushSessionTokenUpdateAction.TransportAction.class)}).with(SessionServiceConfigApi.ACTION_HANDLERS);
    }

    @Override
    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        this.configVarService = baseDependencies.getConfigVarService();
        this.configVarService.requestRandomKey("sessions_signing_key", 512, "authc");
        PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt(baseDependencies.getLocalClient());
        this.sessionService = new SessionService(baseDependencies.getConfigurationRepository(), privilegedConfigClient, baseDependencies.getStaticSettings(), baseDependencies.getPrivilegesEvaluator(), baseDependencies.getAuditLog(), baseDependencies.getThreadPool(), baseDependencies.getClusterService(), baseDependencies.getProtectedConfigIndexService(), new SessionServiceConfig(), baseDependencies.getBlockedIpRegistry(), baseDependencies.getBlockedUserRegistry(), this.componentState);
        this.sessionTokenAuthenticationDomain = new SessionTokenAuthenticationDomain(this.sessionService);
        this.sessionRestAction.setSessionService(this.sessionService);
        baseDependencies.getConfigurationRepository().subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<SessionServiceConfig> config = configMap.get(SessionServiceConfig.TYPE);
                if (config != null && config.getCEntry("default") != null) {
                    SessionModule.this.sessionService.setConfig(config.getCEntry("default"));
                    SessionModule.this.componentState.setConfigVersion(config.getDocVersion());
                    SessionModule.this.componentState.setState(ComponentState.State.INITIALIZED, "using_config");
                } else {
                    try {
                        SessionServiceConfig defaultConfig = SessionServiceConfig.getDefault(SessionModule.this.configVarService);
                        if (defaultConfig != null) {
                            SessionModule.this.sessionService.setConfig(defaultConfig);
                            SessionModule.this.componentState.setState(ComponentState.State.INITIALIZED, "using_default_config");
                        } else {
                            log.trace("Could not yet initialize session service, as the auto-generated key is still not available");
                        }
                    }
                    catch (Exception e) {
                        log.error("Error while getting default config for session service", (Throwable)e);
                        SessionModule.this.componentState.setFailed((Throwable)e);
                    }
                }
            }
        });
        return Arrays.asList(this.sessionService);
    }

    @Override
    public StaticSettings.AttributeSet getSettings() {
        return StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{SessionService.INDEX_NAME, SessionService.CLEANUP_INTERVAL});
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    @Override
    public List<AuthenticationDomain<HttpAuthenticationFrontend>> getImplicitHttpAuthenticationDomains() {
        return Collections.singletonList(this.sessionTokenAuthenticationDomain);
    }

    @Override
    public ImmutableSet<String> getPublicCapabilities() {
        return ImmutableSet.of((Object)"login_sessions");
    }
}

