/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.signals.actions.summary.ActionProperties;
import com.floragunn.signals.actions.summary.RangesFilters;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;

class WatchFilter {
    private final String watchId;
    private final List<String> watchStatusCodes;
    private final List<String> severities;
    private final List<String> actionNames;
    private final ActionProperties actionProperties;
    private final RangesFilters ranges;

    WatchFilter(String watchId, List<String> watchStatusCodes, List<String> severities, List<String> actionNames, RangesFilters ranges, ActionProperties actionProperties) {
        this.watchId = watchId;
        this.watchStatusCodes = Objects.requireNonNull(watchStatusCodes, "Watch status code list is null");
        this.severities = Objects.requireNonNull(severities);
        this.actionNames = actionNames;
        this.ranges = ranges;
        this.actionProperties = actionProperties;
    }

    public List<String> getWatchStatusCodes() {
        return this.watchStatusCodes;
    }

    public boolean containsWatchId() {
        return !Strings.isNullOrEmpty((String)this.watchId);
    }

    public String getWatchId() {
        return this.watchId;
    }

    public boolean containsWatchStatusFilter() {
        return !this.watchStatusCodes.isEmpty();
    }

    public boolean containsSeverities() {
        return !this.severities.isEmpty();
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public List<String> getActionNames() {
        return this.actionNames;
    }

    public boolean containsActions() {
        return !this.actionNames.isEmpty();
    }

    public ActionProperties getActionProperties() {
        return this.actionProperties;
    }

    public RangesFilters getRangesFilters() {
        return this.ranges;
    }

    static class Range<T> {
        private final T equalTo;
        private final T greaterThan;
        private final T lessThan;
        private final String fieldName;

        public Range(T equalTo, T greaterThan, T lessThan, String fieldName) {
            this.equalTo = equalTo;
            this.greaterThan = greaterThan;
            this.lessThan = lessThan;
            this.fieldName = fieldName;
        }

        public T getEqualTo() {
            return this.equalTo;
        }

        public T getGreaterThan() {
            return this.greaterThan;
        }

        public T getLessThan() {
            return this.lessThan;
        }

        public boolean containsEqualTo() {
            return this.equalTo != null;
        }

        public boolean containsLessThan() {
            return this.lessThan != null;
        }

        public boolean containsGreaterThan() {
            return this.greaterThan != null;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "Range{equalTo=" + String.valueOf(this.equalTo) + ", greaterThan=" + String.valueOf(this.greaterThan) + ", lessThan=" + String.valueOf(this.lessThan) + ", fieldName='" + this.fieldName + "'}";
        }
    }
}

