/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.read;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogContext;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogDirectoryReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexService;

public class ReadLogDirectoryReaderWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    private static final Logger log = LogManager.getLogger(ReadLogDirectoryReaderWrapper.class);
    private final ReadLogContext context;

    public ReadLogDirectoryReaderWrapper(IndexService indexService, AuditLog auditlog, AuditLogConfig complianceConfig) {
        this.context = new ReadLogContext(indexService, auditlog, complianceConfig);
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        try {
            return new ReadLogDirectoryReader(reader, this.context);
        }
        catch (RuntimeException e) {
            log.error("Error in ReadLogIndexDirectoryReaderWrapper", (Throwable)e);
            throw e;
        }
    }
}

