/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JacksonJsonNodeAdapter
extends DocNode {
    private final JsonNode jsonNode;

    public JacksonJsonNodeAdapter(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public JacksonJsonNodeAdapter(JsonNode jsonNode, String key) {
        this.jsonNode = jsonNode;
        this.key = key;
    }

    @Override
    public Object get(String attribute) {
        if (attribute == null) {
            return JacksonJsonNodeAdapter.toBaseType(this.jsonNode, this.key);
        }
        return JacksonJsonNodeAdapter.toBaseType(this.jsonNode.get(attribute), attribute);
    }

    @Override
    public DocNode getAsNode(String attribute) {
        if (attribute == null) {
            return this;
        }
        JsonNode subNode = this.jsonNode.get(attribute);
        if (subNode == null || subNode.isNull()) {
            return DocNode.NULL;
        }
        return new JacksonJsonNodeAdapter(subNode, attribute);
    }

    @Override
    public ImmutableList<DocNode> getAsListOfNodes(String attribute) {
        JsonNode jsonNode = attribute == null ? this.jsonNode : this.jsonNode.get(attribute);
        if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
            return ImmutableList.empty();
        }
        if (jsonNode.isArray()) {
            ImmutableList.Builder list = new ImmutableList.Builder(jsonNode.size());
            for (JsonNode subNode : jsonNode) {
                list.add((Object)new JacksonJsonNodeAdapter(subNode));
            }
            return list.build();
        }
        return ImmutableList.of((Object)new JacksonJsonNodeAdapter(jsonNode, attribute));
    }

    @Override
    public ImmutableList<Object> toList() {
        if (this.jsonNode.isNull() || this.jsonNode.isMissingNode()) {
            return ImmutableList.empty();
        }
        if (this.jsonNode.isArray()) {
            ImmutableList.Builder list = new ImmutableList.Builder(this.jsonNode.size());
            for (JsonNode subNode : this.jsonNode) {
                list.add(JacksonJsonNodeAdapter.toBaseType(subNode, null));
            }
            return list.build();
        }
        return ImmutableList.of((Object)JacksonJsonNodeAdapter.toBaseType(this.jsonNode, null));
    }

    @Override
    public <R> ImmutableList<R> getList(String attribute, ValidatingFunction<String, R> conversionFunction, Object expected) throws ConfigValidationException {
        JsonNode jsonNode = attribute == null ? this.jsonNode : this.jsonNode.get(attribute);
        if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
            return null;
        }
        ImmutableList.Builder result = new ImmutableList.Builder(jsonNode.size());
        ValidationErrors validationErrors = new ValidationErrors();
        int index = 0;
        for (JsonNode subNode : jsonNode) {
            try {
                if (subNode.isNull() || subNode.isMissingNode()) {
                    result.add(null);
                } else {
                    result.add(conversionFunction.apply(subNode.textValue()));
                }
            }
            catch (Exception e) {
                validationErrors.add(new InvalidAttributeValue(attribute + "." + index, (Object)subNode.textValue(), expected).cause(e));
            }
            ++index;
        }
        validationErrors.throwExceptionForPresentErrors();
        return result.build();
    }

    @Override
    public BigDecimal getBigDecimal(String attribute) throws ConfigValidationException {
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.decimalValue();
            }
            throw new ConfigValidationException(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"number"));
        }
        return null;
    }

    private static Object toBaseType(JsonNode jsonNode, String key) {
        if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
            return null;
        }
        if (jsonNode.isNumber()) {
            return jsonNode.numberValue();
        }
        if (jsonNode.isTextual()) {
            return jsonNode.textValue();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.booleanValue();
        }
        if (jsonNode.isObject()) {
            return new JacksonJsonNodeAdapter(jsonNode, key);
        }
        if (jsonNode.isArray()) {
            return JacksonJsonNodeAdapter.toListOfBaseType(jsonNode);
        }
        throw new RuntimeException("Unexpected type: " + jsonNode);
    }

    private static List<Object> toListOfBaseType(JsonNode jsonNode) {
        ArrayList<Object> list = new ArrayList<Object>(jsonNode.size());
        for (JsonNode subNode : jsonNode) {
            list.add(JacksonJsonNodeAdapter.toBaseType(subNode, null));
        }
        return list;
    }

    @Override
    public ImmutableMap<String, Object> toMap() {
        return JacksonJsonNodeAdapter.toMap(this.jsonNode);
    }

    @Override
    public boolean isMap() {
        return this.jsonNode instanceof ObjectNode;
    }

    @Override
    public boolean isList(String attribute) {
        if (attribute != null) {
            return this.jsonNode.path(attribute).isArray();
        }
        return this.jsonNode.isArray();
    }

    @Override
    public boolean isList() {
        return this.jsonNode.isArray();
    }

    @Override
    public int size() {
        return this.jsonNode.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jsonNode.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.jsonNode instanceof ObjectNode && key instanceof String) {
            return ((ObjectNode)this.jsonNode).has((String)key);
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        if (this.jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)this.jsonNode;
            HashSet<String> result = new HashSet<String>(objectNode.size());
            Iterator iter = objectNode.fieldNames();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.jsonNode instanceof ObjectNode) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (String key : this.keySet()) {
                result.add(this.get(key));
            }
            return result;
        }
        if (this.jsonNode instanceof ArrayNode) {
            return JacksonJsonNodeAdapter.toListOfBaseType(this.jsonNode);
        }
        if (!this.jsonNode.isNull() && !this.jsonNode.isMissingNode()) {
            return Collections.singleton(JacksonJsonNodeAdapter.toBaseType(this.jsonNode, this.key));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.jsonNode instanceof ObjectNode) {
            LinkedHashSet<Map.Entry<String, Object>> result = new LinkedHashSet<Map.Entry<String, Object>>();
            Iterator iter = ((ObjectNode)this.jsonNode).fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                result.add(Maps.immutableEntry((Object)((String)entry.getKey()), (Object)JacksonJsonNodeAdapter.toBaseType((JsonNode)entry.getValue(), (String)entry.getKey())));
            }
            return result;
        }
        return Collections.emptySet();
    }

    private static ImmutableMap<String, Object> toMap(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            OrderedImmutableMap.Builder result = new OrderedImmutableMap.Builder(objectNode.size());
            Iterator iter = objectNode.fields();
            while (iter.hasNext()) {
                Map.Entry field = (Map.Entry)iter.next();
                result.put((Object)((String)field.getKey()), JacksonJsonNodeAdapter.toObject((JsonNode)field.getValue()));
            }
            return result.build();
        }
        return OrderedImmutableMap.of((Object)"_value", (Object)JacksonJsonNodeAdapter.toObject(jsonNode));
    }

    private static Object toObject(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode instanceof ObjectNode) {
            return JacksonJsonNodeAdapter.toMap(jsonNode);
        }
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ImmutableList.Builder result = new ImmutableList.Builder(arrayNode.size());
            for (JsonNode child : arrayNode) {
                result.add(JacksonJsonNodeAdapter.toObject(child));
            }
            return result.build();
        }
        if (jsonNode instanceof NullNode) {
            return null;
        }
        if (jsonNode instanceof IntNode) {
            return ((NumericNode)jsonNode).asInt();
        }
        if (jsonNode instanceof LongNode) {
            return ((NumericNode)jsonNode).asLong();
        }
        if (jsonNode instanceof NumericNode) {
            return ((NumericNode)jsonNode).asDouble();
        }
        if (jsonNode instanceof BooleanNode) {
            return ((BooleanNode)jsonNode).asBoolean();
        }
        if (jsonNode instanceof TextNode) {
            return ((TextNode)jsonNode).asText();
        }
        return jsonNode.toString();
    }

    @Override
    public DocNode splitDottedAttributeNamesToTree() throws UnexpectedDocumentStructureException {
        throw new UnsupportedOperationException();
    }
}

