/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.state;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.signals.NoSuchActionException;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.action.invokers.AlertAction;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.result.Status;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.state.ActionState;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class WatchState
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(WatchState.class);
    private Map<String, ActionState> actions = new ConcurrentHashMap<String, ActionState>();
    private volatile WatchExecutionContextData lastExecutionContextData;
    private final String tenant;
    private volatile Status lastStatus;
    private boolean active = true;
    private String node;
    private boolean refreshBeforeExecuting;
    private final transient Instant creationTime = Instant.now();

    public WatchState(String tenant) {
        this.tenant = tenant;
    }

    public WatchState(String tenant, String node) {
        this.tenant = tenant;
        this.node = node;
    }

    public ActionState getActionState(String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException("watchId is null");
        }
        return this.actions.computeIfAbsent(actionId, key -> new ActionState());
    }

    public boolean hasAction(String actionId) {
        Preconditions.checkArgument((actionId != null ? 1 : 0) != 0, (Object)"action id is missing");
        return this.actions.containsKey(actionId);
    }

    public boolean isActionMissing(String actionId) {
        return !this.hasAction(actionId);
    }

    public Map<String, Ack> ack(String user, Watch watch) {
        HashMap<String, ActionState> allActionStates = new HashMap<String, ActionState>(this.actions);
        HashMap<String, Ack> ackedActions = new HashMap<String, Ack>(allActionStates.size());
        for (Map.Entry entry : allActionStates.entrySet()) {
            try {
                AlertAction action = watch.getActionByName((String)entry.getKey());
                if (!action.isAckEnabled()) {
                    log.debug("Action is not marked as acknowledgeable: " + (String)entry.getKey() + "; skipping.");
                    continue;
                }
                ActionState actionState = (ActionState)entry.getValue();
                if (!actionState.ackIfPossible(user)) continue;
                Ack acked = actionState.getAcked();
                ackedActions.put((String)entry.getKey(), acked);
            }
            catch (NoSuchActionException e) {
                log.error("Error in ack(): Cannot find action " + (String)entry.getKey(), (Throwable)e);
            }
        }
        return ackedActions;
    }

    public List<String> unack(String user) {
        HashMap<String, ActionState> allActionStates = new HashMap<String, ActionState>(this.actions);
        ArrayList<String> unackedActions = new ArrayList<String>(allActionStates.size());
        for (Map.Entry entry : allActionStates.entrySet()) {
            if (!((ActionState)entry.getValue()).unackIfPossible(user)) continue;
            unackedActions.add((String)entry.getKey());
        }
        return unackedActions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_tenant", this.tenant);
        builder.startObject("actions");
        for (Map.Entry<String, ActionState> entry : this.actions.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
        builder.endObject();
        builder.field("last_execution", (ToXContent)this.lastExecutionContextData);
        builder.field("last_status", (ToXContent)this.lastStatus);
        builder.field("node", this.node);
        builder.endObject();
        return builder;
    }

    public String toJsonString() {
        return Strings.toString((ToXContent)this);
    }

    public static WatchState createFromJson(String tenant, String json) throws DocumentParseException {
        return WatchState.createFrom(tenant, DocNode.parse((Format)Format.JSON).from(json));
    }

    public static WatchState createFrom(String tenant, DocNode jsonNode) {
        WatchState result = new WatchState(tenant);
        if (jsonNode.hasNonNull("last_execution")) {
            try {
                result.lastExecutionContextData = WatchExecutionContextData.create(jsonNode.getAsNode("last_execution"));
            }
            catch (Exception e) {
                log.error("Error while parsing watch state from index " + String.valueOf(jsonNode), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("actions")) {
            for (Map.Entry entry : jsonNode.getAsNode("actions").toMap().entrySet()) {
                result.actions.put((String)entry.getKey(), ActionState.createFrom(DocNode.wrap(entry.getValue())));
            }
        }
        if (jsonNode.hasNonNull("last_status")) {
            result.lastStatus = Status.parse(jsonNode.getAsNode("last_status"));
        }
        if (jsonNode.hasNonNull("active")) {
            try {
                result.active = jsonNode.getBoolean("active");
            }
            catch (ConfigValidationException e) {
                log.error("Error while parsing watch state from index " + String.valueOf(jsonNode), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("node")) {
            result.node = jsonNode.getAsString("node");
        }
        return result;
    }

    public static Map<String, Object> getIndexMapping() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        result.put(new NestedValueMap.Path("properties", "_tenant", "type"), (Object)"text");
        result.put(new NestedValueMap.Path("properties", "_tenant", "analyzer"), (Object)"keyword");
        result.put(new NestedValueMap.Path("properties", "last_execution", "type"), (Object)"object");
        result.put(new NestedValueMap.Path("properties", "last_execution", "dynamic"), (Object)true);
        result.put(new NestedValueMap.Path("properties", "last_execution", "properties", "data", "type"), (Object)"object");
        result.put(new NestedValueMap.Path("properties", "last_execution", "properties", "data", "dynamic"), (Object)true);
        result.put(new NestedValueMap.Path("properties", "last_execution", "properties", "data", "enabled"), (Object)false);
        return result;
    }

    public SeverityLevel getLastSeverityLevel() {
        if (this.lastExecutionContextData != null && this.lastExecutionContextData.getSeverity() != null) {
            return this.lastExecutionContextData.getSeverity().getLevel();
        }
        return null;
    }

    public WatchExecutionContextData getLastExecutionContextData() {
        return this.lastExecutionContextData;
    }

    public void setLastExecutionContextData(WatchExecutionContextData lastExecutionContextData) {
        this.lastExecutionContextData = lastExecutionContextData;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Status getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(Status lastStatus) {
        this.lastStatus = lastStatus;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean isRefreshBeforeExecuting() {
        return this.refreshBeforeExecuting;
    }

    public void setRefreshBeforeExecuting(boolean refreshBeforeExecuting) {
        this.refreshBeforeExecuting = refreshBeforeExecuting;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }
}

