/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.CertificationUtil;

public class SmimeEncryptionConfig
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    @NotNull
    final X509Certificate x509Certificate;
    @Nullable
    final String keyEncapsulationAlgorithm;
    @Nullable
    final String cipherAlgorithm;

    public static SmimeEncryptionConfigBuilder builder() {
        return new SmimeEncryptionConfigBuilder();
    }

    @Generated
    public String toString() {
        return "SmimeEncryptionConfig(x509Certificate=" + this.getX509Certificate() + ", keyEncapsulationAlgorithm=" + this.getKeyEncapsulationAlgorithm() + ", cipherAlgorithm=" + this.getCipherAlgorithm() + ")";
    }

    @NotNull
    @Generated
    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    @Nullable
    @Generated
    public String getKeyEncapsulationAlgorithm() {
        return this.keyEncapsulationAlgorithm;
    }

    @Nullable
    @Generated
    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmimeEncryptionConfig)) {
            return false;
        }
        SmimeEncryptionConfig other = (SmimeEncryptionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X509Certificate this$x509Certificate = this.getX509Certificate();
        X509Certificate other$x509Certificate = other.getX509Certificate();
        if (this$x509Certificate == null ? other$x509Certificate != null : !((Object)this$x509Certificate).equals(other$x509Certificate)) {
            return false;
        }
        String this$keyEncapsulationAlgorithm = this.getKeyEncapsulationAlgorithm();
        String other$keyEncapsulationAlgorithm = other.getKeyEncapsulationAlgorithm();
        if (this$keyEncapsulationAlgorithm == null ? other$keyEncapsulationAlgorithm != null : !this$keyEncapsulationAlgorithm.equals(other$keyEncapsulationAlgorithm)) {
            return false;
        }
        String this$cipherAlgorithm = this.getCipherAlgorithm();
        String other$cipherAlgorithm = other.getCipherAlgorithm();
        return !(this$cipherAlgorithm == null ? other$cipherAlgorithm != null : !this$cipherAlgorithm.equals(other$cipherAlgorithm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SmimeEncryptionConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $x509Certificate = this.getX509Certificate();
        result = result * 59 + ($x509Certificate == null ? 43 : ((Object)$x509Certificate).hashCode());
        String $keyEncapsulationAlgorithm = this.getKeyEncapsulationAlgorithm();
        result = result * 59 + ($keyEncapsulationAlgorithm == null ? 43 : $keyEncapsulationAlgorithm.hashCode());
        String $cipherAlgorithm = this.getCipherAlgorithm();
        result = result * 59 + ($cipherAlgorithm == null ? 43 : $cipherAlgorithm.hashCode());
        return result;
    }

    @Generated
    public SmimeEncryptionConfig(@NotNull X509Certificate x509Certificate, @Nullable String keyEncapsulationAlgorithm, @Nullable String cipherAlgorithm) {
        if (x509Certificate == null) {
            throw new NullPointerException("x509Certificate is marked non-null but is null");
        }
        this.x509Certificate = x509Certificate;
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public static class SmimeEncryptionConfigBuilder {
        private X509Certificate x509Certificate;
        private String keyEncapsulationAlgorithm;
        private String cipherAlgorithm;

        public SmimeEncryptionConfigBuilder x509Certificate(@NotNull X509Certificate x509Certificate) {
            this.x509Certificate = x509Certificate;
            return this;
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
        public SmimeEncryptionConfigBuilder x509Certificate(@NotNull String pemFile) {
            try {
                return this.x509Certificate(new FileInputStream(pemFile));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(String.format("Error reading from file: %s", pemFile), e);
            }
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
        public SmimeEncryptionConfigBuilder x509Certificate(@NotNull File pemFile) {
            try {
                return this.x509Certificate(new FileInputStream(pemFile));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(String.format("Error reading from file: %s", pemFile), e);
            }
        }

        public SmimeEncryptionConfigBuilder x509Certificate(@NotNull InputStream pemStream) {
            try {
                return this.x509Certificate(CertificationUtil.readFromPem(pemStream));
            }
            catch (CertificateException e) {
                throw new IllegalStateException("Was unable to convert PEM data to X509 certificate", e);
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("Unable to load certificate (missing bouncy castle), is the S/MIME module on the class path?", e);
            }
        }

        public SmimeEncryptionConfigBuilder keyEncapsulationAlgorithm(@Nullable String keyEncapsulationAlgorithm) {
            this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
            return this;
        }

        public SmimeEncryptionConfigBuilder cipherAlgorithm(@Nullable String cipherAlgorithm) {
            this.cipherAlgorithm = cipherAlgorithm;
            return this;
        }

        public SmimeEncryptionConfig build() {
            return new SmimeEncryptionConfig(this.x509Certificate, this.keyEncapsulationAlgorithm, this.cipherAlgorithm);
        }

        @Generated
        public String toString() {
            return "SmimeEncryptionConfig.SmimeEncryptionConfigBuilder(x509Certificate=" + this.x509Certificate + ", keyEncapsulationAlgorithm=" + this.keyEncapsulationAlgorithm + ", cipherAlgorithm=" + this.cipherAlgorithm + ")";
        }
    }
}

