/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryAction;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryData;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryRequest;
import com.floragunn.signals.actions.summary.SafeDocNodeReader;
import com.floragunn.signals.actions.summary.SortParser;
import com.floragunn.signals.actions.summary.WatchActionNames;
import com.floragunn.signals.actions.summary.WatchFilter;
import com.floragunn.signals.actions.summary.WatchRepository;
import com.floragunn.signals.actions.summary.WatchStateRepository;
import com.floragunn.signals.watch.result.Status;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.jetbrains.annotations.NotNull;

public class LoadOperatorSummaryHandler
extends Action.Handler<LoadOperatorSummaryRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(LoadOperatorSummaryHandler.class);
    private static final int DEFAULT_MAX_WATCH_RESULTS = 1500;
    public static final String REASON_FAILED_WATCH = "failed_watch";
    public static final String REASON_NEVER_EXECUTED_WATCH_WITH_SEVERITY = "never_executed_watch_with_severity";
    public static final String REASON_MATCH_FILTER = "match_filter";
    private final WatchStateRepository watchStateRepository;
    private final WatchRepository watchRepository;
    private final Signals signals;

    @Inject
    public LoadOperatorSummaryHandler(Action.HandlerDependencies handlerDependencies, NodeClient nodeClient, Signals signals) {
        super((Action)LoadOperatorSummaryAction.INSTANCE, handlerDependencies);
        this.signals = signals;
        this.watchStateRepository = new WatchStateRepository(this.getStateIndexName(), PrivilegedConfigClient.adapt((Client)nodeClient));
        this.watchRepository = new WatchRepository(this.getWatchIndexName(), PrivilegedConfigClient.adapt((Client)nodeClient));
    }

    protected CompletableFuture<StandardResponse> doExecute(LoadOperatorSummaryRequest request) {
        return this.supplyAsync(() -> {
            try {
                String tenant = request.getTenant();
                List<WatchActionNames> watchesWithSeveritiesPreFilteredById = this.watchRepository.searchWatchIdsWithSeverityAndIdPrefix(tenant, request.getWatchFilter().getWatchId(), 1500);
                List<String> initialWatchIdsList = watchesWithSeveritiesPreFilteredById.stream().map(WatchActionNames::watchIdWithTenantPrefix).collect(Collectors.toList());
                LoadOperatorSummaryData failedWatchesData = this.loadFailedWatches(request, initialWatchIdsList);
                LoadOperatorSummaryData notExecutedWatchesWithSeverity = this.loadNeverExecutedWatchesWithSeverity(tenant, request.getSizeOrDefault() - failedWatchesData.getSize(), watchesWithSeveritiesPreFilteredById);
                LoadOperatorSummaryData loadOperatorSummaryData = this.loadWatchesByFilter(request.getSortingOrDefault(), request.getSizeOrDefault() - failedWatchesData.getSize() - notExecutedWatchesWithSeverity.getSize(), request.getWatchFilter(), initialWatchIdsList).filterActions(watchesWithSeveritiesPreFilteredById);
                LoadOperatorSummaryData result = failedWatchesData.with(notExecutedWatchesWithSeverity).with(loadOperatorSummaryData).withActive(watchesWithSeveritiesPreFilteredById);
                return new StandardResponse(200).data((Object)result);
            }
            catch (Exception ex) {
                log.error("Cannot load signal watch state summary", (Throwable)ex);
                return new StandardResponse(400).error(ex.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LoadOperatorSummaryData loadWatchesByFilter(String sortingString, int size, WatchFilter watchFilter, List<String> watchIds) {
        if (size <= 0 || watchIds.isEmpty()) {
            return new LoadOperatorSummaryData(List.of());
        }
        List<SortParser.SortByField> sorting = SortParser.parseSortingExpression(sortingString);
        SearchResponse search = this.watchStateRepository.search(watchFilter, sorting, size, watchIds);
        try {
            LoadOperatorSummaryData loadOperatorSummaryData = this.convertSearchResultToResponse(search, REASON_MATCH_FILTER);
            return loadOperatorSummaryData;
        }
        finally {
            search.decRef();
        }
    }

    private LoadOperatorSummaryData loadNeverExecutedWatchesWithSeverity(String tenant, int size, List<WatchActionNames> watchesWithSeveritiesPreFilteredById) {
        List<String> watchIds = watchesWithSeveritiesPreFilteredById.stream().map(WatchActionNames::watchIdWithTenantPrefix).toList();
        if (size <= 0 || watchIds.isEmpty()) {
            return new LoadOperatorSummaryData(List.of());
        }
        SearchResponse response = this.watchStateRepository.findNeverExecutedWatchesWithSeverity(tenant, watchIds, size);
        return this.convertSearchResultToResponse(response, REASON_NEVER_EXECUTED_WATCH_WITH_SEVERITY).filterActions(watchesWithSeveritiesPreFilteredById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LoadOperatorSummaryData loadFailedWatches(LoadOperatorSummaryRequest request, Collection<String> watchIdsFilter) {
        List<Status.Code> statusCodes = List.of(Status.Code.ACTION_FAILED, Status.Code.EXECUTION_FAILED);
        LoadOperatorSummaryRequest failedWatchesRequest = request.withWatchStatusCodes(statusCodes);
        List<SortParser.SortByField> sorting = SortParser.parseSortingExpression(request.getSortingOrDefault());
        try {
            SearchResponse failedWatchesResponse = this.watchStateRepository.search(failedWatchesRequest.getWatchFilter(), sorting, request.getSizeOrDefault(), watchIdsFilter);
            LoadOperatorSummaryData loadOperatorSummaryData = this.convertSearchResultToResponse(failedWatchesResponse, REASON_FAILED_WATCH);
            return loadOperatorSummaryData;
        }
        finally {
            failedWatchesRequest.decRef();
        }
    }

    private LoadOperatorSummaryData convertSearchResultToResponse(SearchResponse searchResponse, String reason) {
        log.debug("Watch state search result '{}'", (Object)searchResponse);
        List<LoadOperatorSummaryData.WatchSummary> watches = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> this.toWatchSummary((SearchHit)hit, reason)).collect(Collectors.toList());
        return new LoadOperatorSummaryData(watches);
    }

    private LoadOperatorSummaryData.WatchSummary toWatchSummary(SearchHit documentFields, String reason) {
        try {
            DocNode docNode = DocNode.parse((Format)Format.JSON).from(documentFields.getSourceAsString());
            DocNode docNodeLastStatus = SafeDocNodeReader.findSingleNodeByJsonPath(docNode, "last_status").orElse(DocNode.EMPTY);
            LoadOperatorSummaryData.WatchSeverityDetails severityDetails = SafeDocNodeReader.findSingleNodeByJsonPath(docNode, "last_execution.severity").map(this::nodeToWatchSeverity).orElse(null);
            DocNode actions = docNode.getAsNode("actions");
            HashMap<String, LoadOperatorSummaryData.ActionSummary> mapActionSummary = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
            for (String key : actions.keySet()) {
                mapActionSummary.put(key, this.nodeToActionDetails(actions.getAsNode(key)));
            }
            return new LoadOperatorSummaryData.WatchSummary(documentFields.getId(), docNodeLastStatus.getAsString("code"), docNodeLastStatus.getAsString("severity"), docNodeLastStatus.getAsString("detail"), severityDetails, mapActionSummary, reason, null);
        }
        catch (DocumentParseException e) {
            throw new ElasticsearchStatusException("Cannot parse watch state search response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private LoadOperatorSummaryData.ActionSummary nodeToActionDetails(DocNode node) {
        try {
            DocNode lastStatus = node.getAsNode("last_status");
            String statusCode = null;
            String statusDetails = null;
            if (Objects.nonNull(lastStatus)) {
                statusCode = lastStatus.getAsString("code");
                statusDetails = lastStatus.getAsString("detail");
            }
            String ackBy = null;
            Instant ackOn = null;
            DocNode ackedNode = node.getAsNode("acked");
            if (Objects.nonNull(ackedNode)) {
                ackBy = ackedNode.getAsString("by");
                ackOn = SafeDocNodeReader.getInstantValue(ackedNode, "on");
            }
            return new LoadOperatorSummaryData.ActionSummary(SafeDocNodeReader.getInstantValue(node, "last_triggered"), SafeDocNodeReader.getInstantValue(node, "last_check"), node.getBoolean("last_check_result"), SafeDocNodeReader.getInstantValue(node, "last_execution"), node.getAsString("last_error"), statusCode, statusDetails, ackBy, ackOn);
        }
        catch (ConfigValidationException e) {
            throw new ElasticsearchStatusException("Cannot parse watch state action details", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private LoadOperatorSummaryData.WatchSeverityDetails nodeToWatchSeverity(DocNode node) {
        return new LoadOperatorSummaryData.WatchSeverityDetails(node.getAsString("level"), SafeDocNodeReader.getLongValue(node, "level_numeric"), SafeDocNodeReader.getDoubleValue(node, "value"), SafeDocNodeReader.getDoubleValue(node, "threshold"));
    }

    private String getStateIndexName() {
        return this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getWatchesState();
    }

    private String getWatchIndexName() {
        return this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getWatches();
    }
}

