/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.CompactAttribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CompactEntry
implements Serializable {
    private static final long serialVersionUID = 8067151651120794058L;
    @NotNull
    private final CompactAttribute[] attributes;
    private int hashCode;
    @NotNull
    private final String dn;

    public CompactEntry(@NotNull Entry entry) {
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.hashCode = -1;
        Collection<Attribute> attrs = entry.getAttributes();
        this.attributes = new CompactAttribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new CompactAttribute(iterator.next());
        }
    }

    @NotNull
    public String getDN() {
        return this.dn;
    }

    @NotNull
    public DN getParsedDN() throws LDAPException {
        return new DN(this.dn);
    }

    @Nullable
    public RDN getRDN() throws LDAPException {
        return this.getParsedDN().getRDN();
    }

    @Nullable
    public DN getParentDN() throws LDAPException {
        return this.getParsedDN().getParent();
    }

    @Nullable
    public String getParentDNString() throws LDAPException {
        return this.getParsedDN().getParentString();
    }

    public boolean hasAttribute(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (CompactAttribute a : this.attributes) {
            if (!a.toAttribute().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(@NotNull String attributeName, @NotNull String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName) || !a.toAttribute().hasValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName) || !a.toAttribute().hasValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObjectClass(@NotNull String objectClassName) {
        return this.hasAttributeValue("objectClass", objectClassName);
    }

    @NotNull
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(this.attributes.length);
        for (CompactAttribute a : this.attributes) {
            attrList.add(a.toAttribute());
        }
        return Collections.unmodifiableCollection(attrList);
    }

    @Nullable
    public Attribute getAttribute(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.toAttribute();
        }
        return null;
    }

    @NotNull
    public List<Attribute> getAttributesWithOptions(@NotNull String baseName, @NotNull Set<String> options) {
        return this.toEntry().getAttributesWithOptions(baseName, options);
    }

    @Nullable
    public String getAttributeValue(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            String[] values = a.getStringValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        return null;
    }

    @Nullable
    public byte[] getAttributeValueBytes(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            byte[][] values = a.getByteValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        return null;
    }

    @Nullable
    public Boolean getAttributeValueAsBoolean(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsBoolean();
    }

    @Nullable
    public Date getAttributeValueAsDate(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsDate();
    }

    @Nullable
    public DN getAttributeValueAsDN(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsDN();
    }

    @Nullable
    public Integer getAttributeValueAsInteger(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsInteger();
    }

    @Nullable
    public Long getAttributeValueAsLong(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsLong();
    }

    @Nullable
    public String[] getAttributeValues(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.getStringValues();
        }
        return null;
    }

    @Nullable
    public byte[][] getAttributeValueByteArrays(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.getByteValues();
        }
        return null;
    }

    @Nullable
    public Attribute getObjectClassAttribute() {
        return this.getAttribute("objectClass");
    }

    @Nullable
    public String[] getObjectClassValues() {
        return this.getAttributeValues("objectClass");
    }

    @NotNull
    public Entry toEntry() {
        Attribute[] attrs = new Attribute[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            attrs[i] = this.attributes[i].toAttribute();
        }
        return new Entry(this.dn, attrs);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toEntry().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof CompactEntry)) {
            return false;
        }
        return this.toEntry().equals(((CompactEntry)o).toEntry());
    }

    @NotNull
    public String[] toLDIF() {
        return this.toLDIF(0);
    }

    @NotNull
    public String[] toLDIF(int wrapColumn) {
        return this.toEntry().toLDIF(wrapColumn);
    }

    public void toLDIF(@NotNull ByteStringBuffer buffer) {
        this.toLDIF(buffer, 0);
    }

    public void toLDIF(@NotNull ByteStringBuffer buffer, int wrapColumn) {
        this.toEntry().toLDIF(buffer, wrapColumn);
    }

    @NotNull
    public String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, 0);
        return buffer.toString();
    }

    @NotNull
    public String toLDIFString(int wrapColumn) {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, wrapColumn);
        return buffer.toString();
    }

    public void toLDIFString(@NotNull StringBuilder buffer) {
        this.toLDIFString(buffer, 0);
    }

    public void toLDIFString(@NotNull StringBuilder buffer, int wrapColumn) {
        this.toEntry().toLDIFString(buffer, wrapColumn);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Entry(dn='");
        buffer.append(this.dn);
        buffer.append("', attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.attributes[i].toAttribute().toString(buffer);
        }
        buffer.append("})");
    }
}

