/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.internal.util.MiscUtil;

public class SmimeSigningConfig {
    @NotNull
    private final Pkcs12Config pkcs12Config;
    @Nullable
    private final String signatureAlgorithm;

    public static SmimeSigningConfigBuilder builder() {
        return new SmimeSigningConfigBuilder();
    }

    @Generated
    public String toString() {
        return "SmimeSigningConfig(pkcs12Config=" + this.getPkcs12Config() + ", signatureAlgorithm=" + this.getSignatureAlgorithm() + ")";
    }

    @NotNull
    @Generated
    public Pkcs12Config getPkcs12Config() {
        return this.pkcs12Config;
    }

    @Nullable
    @Generated
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmimeSigningConfig)) {
            return false;
        }
        SmimeSigningConfig other = (SmimeSigningConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pkcs12Config this$pkcs12Config = this.getPkcs12Config();
        Pkcs12Config other$pkcs12Config = other.getPkcs12Config();
        if (this$pkcs12Config == null ? other$pkcs12Config != null : !((Object)this$pkcs12Config).equals(other$pkcs12Config)) {
            return false;
        }
        String this$signatureAlgorithm = this.getSignatureAlgorithm();
        String other$signatureAlgorithm = other.getSignatureAlgorithm();
        return !(this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !this$signatureAlgorithm.equals(other$signatureAlgorithm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SmimeSigningConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pkcs12Config $pkcs12Config = this.getPkcs12Config();
        result = result * 59 + ($pkcs12Config == null ? 43 : ((Object)$pkcs12Config).hashCode());
        String $signatureAlgorithm = this.getSignatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : $signatureAlgorithm.hashCode());
        return result;
    }

    @Generated
    public SmimeSigningConfig(@NotNull Pkcs12Config pkcs12Config, @Nullable String signatureAlgorithm) {
        if (pkcs12Config == null) {
            throw new NullPointerException("pkcs12Config is marked non-null but is null");
        }
        this.pkcs12Config = pkcs12Config;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public static class SmimeSigningConfigBuilder {
        private Pkcs12Config pkcs12Config;
        private String signatureAlgorithm;

        public SmimeSigningConfigBuilder pkcs12Config(@NotNull Pkcs12Config pkcs12Config) {
            this.pkcs12Config = pkcs12Config;
            return this;
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
        public SmimeSigningConfigBuilder pkcs12Config(@NotNull File pkcs12StoreFile, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
            try {
                return this.pkcs12Config(new FileInputStream(pkcs12StoreFile), storePassword, keyAlias, keyPassword);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error reading from file: %s", pkcs12StoreFile), e);
            }
        }

        public SmimeSigningConfigBuilder pkcs12Config(@NotNull InputStream pkcs12StoreStream, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
            byte[] pkcs12StoreData;
            try {
                pkcs12StoreData = MiscUtil.readInputStreamToBytes(pkcs12StoreStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Was unable to read S/MIME data from input stream", e);
            }
            return this.pkcs12Config(pkcs12StoreData, storePassword, keyAlias, keyPassword);
        }

        public SmimeSigningConfigBuilder pkcs12Config(byte @NotNull [] pkcs12StoreData, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
            return this.pkcs12Config(Pkcs12Config.builder().pkcs12Store(pkcs12StoreData).storePassword(storePassword).keyAlias(keyAlias).keyPassword(keyPassword).build());
        }

        public SmimeSigningConfigBuilder signatureAlgorithm(@Nullable String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public SmimeSigningConfig build() {
            return new SmimeSigningConfig(this.pkcs12Config, this.signatureAlgorithm);
        }

        @Generated
        public String toString() {
            return "SmimeSigningConfig.SmimeSigningConfigBuilder(pkcs12Config=" + this.pkcs12Config + ", signatureAlgorithm=" + this.signatureAlgorithm + ")";
        }
    }
}

