/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FrontendDataMigrationInterceptor;
import com.floragunn.searchguard.enterprise.femt.KibanaActionsProvider;
import com.floragunn.searchguard.enterprise.femt.RoleBasedTenantAuthorization;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandlerFactory;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.script.Script;

public class MultiTenancyAuthorizationFilter
implements SyncAuthorizationFilter {
    static final String TEMP_MIGRATION_INDEX_NAME_POSTFIX_1 = "_reindex_temp";
    static final String TEMP_MIGRATION_INDEX_NAME_POSTFIX_2 = "_reindex_temp_alias";
    public static final String SG_FILTER_LEVEL_FEMT_DONE = "_sg_filter_level_femt_done";
    private static final ImmutableSet<String> READ_ONLY_ALLOWED_ACTIONS = ImmutableSet.of((Object)"indices:admin/get", (Object[])new String[]{"indices:data/read/get", "indices:data/read/search", "indices:data/read/msearch", "indices:data/read/mget", "indices:data/read/mget[shard]", "indices:data/read/open_point_in_time"});
    private final Action KIBANA_ALL_SAVED_OBJECTS_WRITE;
    private final Action KIBANA_ALL_SAVED_OBJECTS_READ;
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String kibanaServerUsername;
    private final String kibanaIndexName;
    private final String kibanaIndexNamePrefix;
    private final Pattern versionedKibanaIndexPattern;
    private final boolean enabled;
    private final boolean privateTenantEnabled;
    private final ThreadContext threadContext;
    private final ImmutableList<String> indexSubNames = ImmutableList.of((Object)"alerting_cases", (Object)"analytics", (Object)"security_solution", (Object[])new String[]{"ingest"});
    private final RoleBasedTenantAuthorization tenantAuthorization;
    private final FrontendDataMigrationInterceptor frontendDataMigrationInterceptor;
    private final RequestHandlerFactory requestHandlerFactory;
    private final TenantManager tenantManager;

    public MultiTenancyAuthorizationFilter(FeMultiTenancyConfig config, RoleBasedTenantAuthorization tenantAuthorization, TenantManager tenantManager, Actions actions, ThreadContext threadContext, Client nodeClient, RequestHandlerFactory requestHandlerFactory) {
        this.enabled = config.isEnabled();
        this.privateTenantEnabled = config.isPrivateTenantEnabled();
        this.kibanaServerUsername = config.getServerUsername();
        this.kibanaIndexName = config.getIndex();
        this.kibanaIndexNamePrefix = this.kibanaIndexName + "_";
        this.versionedKibanaIndexPattern = Pattern.compile("(" + Pattern.quote(this.kibanaIndexName) + this.toPatternFragment((Collection<String>)this.indexSubNames) + ")(_[0-9]+\\.[0-9]+\\.[0-9]+(_[0-9]{3})?)?(" + Pattern.quote(TEMP_MIGRATION_INDEX_NAME_POSTFIX_1) + "|" + Pattern.quote(TEMP_MIGRATION_INDEX_NAME_POSTFIX_2) + ")?");
        this.KIBANA_ALL_SAVED_OBJECTS_WRITE = KibanaActionsProvider.getKibanaWriteAction(actions);
        this.KIBANA_ALL_SAVED_OBJECTS_READ = KibanaActionsProvider.getKibanaReadAction(actions);
        this.threadContext = threadContext;
        this.tenantAuthorization = tenantAuthorization;
        this.frontendDataMigrationInterceptor = new FrontendDataMigrationInterceptor(threadContext, nodeClient, config);
        this.requestHandlerFactory = requestHandlerFactory;
        this.tenantManager = tenantManager;
        this.log.info("Filter which supports front-end multi tenancy created, enabled '{}'.", (Object)this.enabled);
    }

    public SyncAuthorizationFilter.Result apply(PrivilegesEvaluationContext context, ActionListener<?> listener) {
        SyncAuthorizationFilter.Result initializationProcessingResult;
        List<IndexInfo> kibanaIndicesInfo;
        if (!this.enabled) {
            this.log.trace("MultiTenancyAuthorizationFilter is disabled");
            return SyncAuthorizationFilter.Result.OK;
        }
        if (this.threadContext.getHeader(SG_FILTER_LEVEL_FEMT_DONE) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("FEMT is already done for: " + this.threadContext.getHeader(SG_FILTER_LEVEL_FEMT_DONE));
            }
            return SyncAuthorizationFilter.Result.PASS_ON_FAST_LANE;
        }
        User user = context.getUser();
        ResolvedIndices requestedResolved = context.getRequestInfo().getResolvedIndices();
        if (this.log.isDebugEnabled()) {
            this.log.debug("apply(" + String.valueOf(context.getAction()) + ", " + String.valueOf(user) + ")\nrequestedResolved: " + String.valueOf(requestedResolved) + "\nrequestedTenant: " + user.getRequestedTenant());
        }
        if ((kibanaIndicesInfo = this.checkForExclusivelyUsedKibanaIndexOrAlias((ActionRequest)context.getRequest(), requestedResolved, user.getRequestedTenant())).isEmpty()) {
            return SyncAuthorizationFilter.Result.OK;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("IndexInfo: " + String.valueOf(kibanaIndicesInfo));
        }
        if (SyncAuthorizationFilter.Result.PASS_ON_FAST_LANE != (initializationProcessingResult = this.frontendDataMigrationInterceptor.process(this.getOriginalIndicesNames(kibanaIndicesInfo), context, listener))) {
            return initializationProcessingResult;
        }
        String requestedTenant = user.getRequestedTenant();
        this.log.trace("User's '{}' requested tenant is '{}'", (Object)user.getName(), (Object)requestedTenant);
        if (this.tenantManager.isTenantHeaderEmpty(requestedTenant)) {
            return SyncAuthorizationFilter.Result.OK;
        }
        try {
            TenantAccess tenantAccess;
            boolean frontendServerUser = user.getName().equals(this.kibanaServerUsername);
            TenantAccess tenantAccess2 = tenantAccess = frontendServerUser ? TenantAccess.FULL_ACCESS : this.getTenantAccess(context, requestedTenant);
            if (this.isTenantAllowed(tenantAccess, context.getUser().getName(), context.getAction(), requestedTenant, context.getRequest())) {
                return this.handle(context, listener);
            }
            return SyncAuthorizationFilter.Result.DENIED;
        }
        catch (PrivilegesEvaluationException e) {
            this.log.error("Error while evaluating privileges for {}, tenant: {}", (Object)user, (Object)requestedTenant, (Object)e);
            return SyncAuthorizationFilter.Result.DENIED;
        }
    }

    private boolean isReadOnlyAllowedRequest(Object request) {
        return this.isUpdateLegacyUrlAliasDuringLoadingDashboard(request);
    }

    private boolean isUpdateLegacyUrlAliasDuringLoadingDashboard(Object request) {
        Predicate<DocWriteRequest> bulkRequestMatcher = req -> {
            if (req.id() == null || !req.id().startsWith("legacy-url-alias")) {
                return false;
            }
            if (!(req instanceof UpdateRequest)) {
                return false;
            }
            UpdateRequest updateRequest = (UpdateRequest)req;
            Script script = updateRequest.script();
            if (script == null) {
                return false;
            }
            if (!"painless".contains(script.getLang())) {
                return false;
            }
            Map params = script.getParams();
            if (params == null || !params.containsKey("type") || !params.containsKey("time")) {
                return false;
            }
            if (!"legacy-url-alias".equals(params.get("type"))) {
                return false;
            }
            String code = script.getIdOrCode();
            return code != null && code.contains("ctx._source[params.type].disabled") && code.contains("ctx._source[params.type].resolveCounter");
        };
        if (request instanceof BulkRequest) {
            BulkRequest bulkRequest = (BulkRequest)request;
            if (bulkRequest.getIndices().size() != 1) {
                return false;
            }
            if (!((String)new ArrayList(bulkRequest.getIndices()).get(0)).startsWith(this.kibanaIndexName)) {
                return false;
            }
            return bulkRequest.requests() != null && bulkRequest.requests().stream().allMatch(bulkRequestMatcher);
        }
        return false;
    }

    private SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, ActionListener<?> listener) {
        Object request = context.getRequest();
        Optional<RequestHandler<RequestHandler>> requestHandler = this.requestHandlerFactory.requestHandlerFor(request);
        String internalTenantName = this.tenantManager.toInternalTenantName(context.getUser());
        return requestHandler.map(handler -> handler.handle(context, internalTenantName, (ActionRequest)request, listener)).orElseGet(() -> {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Not giving {} special treatment for FEMT", request);
            }
            return SyncAuthorizationFilter.Result.OK;
        });
    }

    private TenantAccess getTenantAccess(PrivilegesEvaluationContext context, String requestedTenant) throws PrivilegesEvaluationException {
        if (!this.tenantManager.isTenantHeaderValid(requestedTenant)) {
            this.log.warn("Invalid tenant: " + requestedTenant + "; user: " + String.valueOf(context.getUser()));
            return TenantAccess.INACCESSIBLE;
        }
        if (this.tenantManager.isUserTenantHeader(requestedTenant)) {
            return this.privateTenantEnabled ? TenantAccess.FULL_ACCESS : TenantAccess.INACCESSIBLE;
        }
        return new TenantAccess(this.tenantAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_READ, requestedTenant).isOk(), this.tenantAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_WRITE, requestedTenant).isOk());
    }

    private boolean isTenantAllowed(TenantAccess tenantAccess, String username, Action action, String requestedTenant, Object request) throws PrivilegesEvaluationException {
        if (tenantAccess.isProhibited()) {
            this.log.warn("Tenant {} is not allowed for user {}", (Object)requestedTenant, (Object)username);
            return false;
        }
        if (tenantAccess.isWriteProhibited() && !READ_ONLY_ALLOWED_ACTIONS.contains((Object)action.name()) && !this.isReadOnlyAllowedRequest(request)) {
            this.log.warn("Tenant {} is not allowed to write (user: {})", (Object)requestedTenant, (Object)username);
            return false;
        }
        return true;
    }

    private List<IndexInfo> checkForExclusivelyUsedKibanaIndexOrAlias(ActionRequest request, ResolvedIndices requestedResolved, String requestedTenant) {
        if (requestedResolved.isLocalAll()) {
            return Collections.emptyList();
        }
        Set<String> allQueryIndices = this.getIndices(request);
        List<IndexInfo> multiTenancyRelatedIndices = allQueryIndices.stream().map(this::checkForExclusivelyUsedKibanaIndexOrAlias).filter(Objects::nonNull).collect(Collectors.toList());
        if (!Strings.isNullOrEmpty((String)requestedTenant) && !multiTenancyRelatedIndices.isEmpty() && allQueryIndices.size() != multiTenancyRelatedIndices.size()) {
            String indicesNames = String.join((CharSequence)", ", allQueryIndices);
            this.log.error("Request '{}' is related to multi-tenancy indices and some other indices '{}', requested tenant '{}'", request.getClass(), (Object)indicesNames, (Object)requestedTenant);
        }
        return multiTenancyRelatedIndices;
    }

    private IndexInfo checkForExclusivelyUsedKibanaIndexOrAlias(String aliasOrIndex) {
        Matcher matcher;
        if (aliasOrIndex.equals(this.kibanaIndexName)) {
            return new IndexInfo(aliasOrIndex, this.kibanaIndexName, null);
        }
        if (aliasOrIndex.startsWith(this.kibanaIndexNamePrefix) && (matcher = this.versionedKibanaIndexPattern.matcher(aliasOrIndex)).matches()) {
            return new IndexInfo(aliasOrIndex, matcher.group(1), matcher.group(2));
        }
        return null;
    }

    private Set<String> getOriginalIndicesNames(List<IndexInfo> indicesInfo) {
        return indicesInfo.stream().map(info -> info.originalName).collect(Collectors.toSet());
    }

    private Set<String> getIndices(ActionRequest request) {
        SearchRequest searchRequest;
        if (request instanceof PutMappingRequest) {
            PutMappingRequest putMappingRequest = (PutMappingRequest)request;
            return ImmutableSet.of((Object)(putMappingRequest.getConcreteIndex() != null ? putMappingRequest.getConcreteIndex().getName() : null), (Object[])putMappingRequest.indices());
        }
        if (request instanceof SearchRequest && Objects.nonNull((searchRequest = (SearchRequest)request).pointInTimeBuilder())) {
            BytesReference pointInTimeId = searchRequest.pointInTimeBuilder().getEncodedId();
            return ImmutableSet.ofArray((Object[])SearchContextId.decodeIndices((BytesReference)pointInTimeId));
        }
        if (request instanceof IndicesRequest) {
            if (((IndicesRequest)request).indices() != null) {
                return ImmutableSet.of(Arrays.asList(((IndicesRequest)request).indices()));
            }
            return Collections.emptySet();
        }
        if (request instanceof BulkRequest) {
            return ((BulkRequest)request).getIndices();
        }
        if (request instanceof MultiGetRequest) {
            return ((MultiGetRequest)request).getItems().stream().map(item -> item.index()).collect(Collectors.toSet());
        }
        if (request instanceof MultiSearchRequest) {
            return ((MultiSearchRequest)request).requests().stream().flatMap(r -> Arrays.stream(r.indices())).collect(Collectors.toSet());
        }
        if (request instanceof MultiTermVectorsRequest) {
            return ((MultiTermVectorsRequest)request).getRequests().stream().flatMap(r -> Arrays.stream(r.indices())).collect(Collectors.toSet());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Not supported for multi tenancy: {} ", (Object)request);
        }
        return Collections.emptySet();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private String toPatternFragment(Collection<String> indexSuffixes) {
        StringBuilder result = new StringBuilder("(?:");
        for (String suffix : indexSuffixes) {
            result.append("|_");
            result.append(Pattern.quote(suffix));
        }
        result.append(")");
        return result.toString();
    }

    record TenantAccess(boolean hasReadPermission, boolean hasWritePermission) {
        public static final TenantAccess INACCESSIBLE = new TenantAccess(false, false);
        public static final TenantAccess FULL_ACCESS = new TenantAccess(true, true);

        public boolean hasAnyAccess() {
            return this.hasReadPermission | this.hasWritePermission;
        }

        public boolean isProhibited() {
            return !this.hasAnyAccess();
        }

        public boolean isWriteProhibited() {
            return !this.hasWritePermission;
        }

        public boolean isReadOnly() {
            return !this.hasWritePermission && this.hasReadPermission;
        }
    }

    private class IndexInfo {
        final String originalName;
        final String prefix;
        final String suffix;

        IndexInfo(String originalName, String prefix, String suffix) {
            this.originalName = originalName;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String toString() {
            return "IndexInfo [originalName=" + this.originalName + ", prefix=" + this.prefix + ", suffix=" + this.suffix + "]";
        }
    }
}

