/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.TenantAuthorization;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleBasedTenantAuthorization
implements TenantAuthorization,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedTenantAuthorization.class);
    private final TenantManager tenantManager;
    private final TenantPermissions tenant;
    private final ComponentState componentState;
    private final MetricsLevel metricsLevel;
    private final Measurement<?> tenantActionChecks;
    private final CountAggregation tenantActionCheckResults;
    private final CountAggregation tenantActionCheckResults_ok;
    private final CountAggregation tenantActionCheckResults_insufficient;

    public RoleBasedTenantAuthorization(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, TenantManager tenantManager, MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel;
        this.tenantManager = tenantManager;
        this.tenant = new TenantPermissions(roles, actionGroups, actions, (ImmutableSet<String>)this.tenantManager.getConfiguredTenantNames());
        this.componentState = new ComponentState("role_based_tenant_authorization");
        this.componentState.addParts(new ComponentState[]{this.tenant.getComponentState()});
        this.componentState.updateStateFromParts();
        this.componentState.setConfigVersion(roles.getDocVersion());
        if (metricsLevel.detailedEnabled()) {
            this.tenantActionChecks = new TimeAggregation.Nanoseconds();
            this.tenantActionCheckResults = new CountAggregation();
        } else if (metricsLevel.basicEnabled()) {
            this.tenantActionChecks = new CountAggregation();
            this.tenantActionCheckResults = new CountAggregation();
        } else {
            this.tenantActionChecks = CountAggregation.noop();
            this.tenantActionCheckResults = CountAggregation.noop();
        }
        this.tenantActionCheckResults_ok = this.tenantActionCheckResults.getSubCount("ok");
        this.tenantActionCheckResults_insufficient = this.tenantActionCheckResults.getSubCount("insufficient");
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("tenant_action_check_results", (Measurement)this.tenantActionCheckResults);
            this.componentState.addMetrics("tenant_action_checks", this.tenantActionChecks);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivilegesEvaluationResult hasTenantPermission(PrivilegesEvaluationContext context, Action action, String requestedTenant) throws PrivilegesEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    static class TenantPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableMap<String, ImmutableSet<String>>> actionToTenantToRoles;
        private final ImmutableMap<String, ImmutableMap<Action, ImmutableSet<Template<Pattern>>>> roleToActionToTenantPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState;

        TenantPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, ImmutableSet<String> tenants) {
            ImmutableMap.Builder actionToTenantToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableMap.Builder roleToActionToTenantPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Tenant tenantPermissions : role.getTenantPermissions()) {
                        ImmutableSet permissions = actionGroups.resolve((Collection)tenantPermissions.getAllowedActions());
                        for (String permission : permissions) {
                            for (Template tenantPatternTemplate : tenantPermissions.getTenantPatterns()) {
                                if (tenantPatternTemplate.isConstant()) {
                                    Pattern tenantPattern = (Pattern)tenantPatternTemplate.getConstantValue();
                                    ImmutableSet matchingTenants = tenants.matching((Predicate)tenantPattern);
                                    if (Pattern.isConstant((String)permission)) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)actions.get(permission))).get((Object)tenant)).add((Object)roleName);
                                        }
                                        continue;
                                    }
                                    Pattern actionPattern = Pattern.create((String)permission);
                                    ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                    for (Action.WellKnownAction action : providedPrivileges) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)action)).get((Object)tenant)).add((Object)roleName);
                                        }
                                    }
                                    continue;
                                }
                                if (Pattern.isConstant((String)permission)) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)actions.get(permission))).add((Object)tenantPatternTemplate);
                                    continue;
                                }
                                Pattern actionPattern = Pattern.create((String)permission);
                                ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                for (Action.WellKnownAction action : providedPrivileges) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)action)).add((Object)tenantPatternTemplate);
                                }
                            }
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: " + String.valueOf(entry) + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid configuration in role", (Throwable)e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + String.valueOf(entry) + "\nIgnoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", (Throwable)e, (String)entry.getKey()));
                }
            }
            this.actionToTenantToRoles = actionToTenantToRoles.build(b -> b.build(ImmutableSet.Builder::build));
            this.roleToActionToTenantPattern = roleToActionToTenantPattern.build(b -> b.build(ImmutableSet.Builder::build));
            this.initializationErrors = initializationErrors.build();
            this.componentState = new ComponentState("tenant_permissions");
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

