/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationService;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.persistence.IndexMigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepsFactory;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.injection.guice.Inject;

class StartDataMigrationAction
extends Action<StartDataMigrationRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(StartDataMigrationAction.class);
    public static final String NAME = "cluster:admin:searchguard:config/multitenancy/frontend_data_migration/8_8_0/start";
    public static final StartDataMigrationAction INSTANCE = new StartDataMigrationAction();

    public StartDataMigrationAction() {
        super(NAME, StartDataMigrationRequest::new, StandardResponse::new);
    }

    public static class StartDataMigrationHandler
    extends Action.Handler<StartDataMigrationRequest, StandardResponse> {
        private final DataMigrationService dataMigrationService;

        @Inject
        public StartDataMigrationHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, FeMultiTenancyConfigurationProvider provider, ConfigurationRepository repository) {
            super((Action)INSTANCE, handlerDependencies);
            Objects.requireNonNull(client, "Client is required");
            Objects.requireNonNull(provider, "Multi-tenancy configuration provider is required");
            PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
            IndexMigrationStateRepository migrationStateRepository = new IndexMigrationStateRepository(privilegedConfigClient);
            StepsFactory stepsFactory = new StepsFactory(privilegedConfigClient, provider, repository);
            this.dataMigrationService = new DataMigrationService(migrationStateRepository, stepsFactory);
        }

        protected CompletableFuture<StandardResponse> doExecute(StartDataMigrationRequest request) {
            return this.supplyAsync(() -> {
                try {
                    return this.dataMigrationService.migrateData(request.getConfig());
                }
                catch (Exception ex) {
                    log.error("Unexpected error during multi-tenancy data migration occurred.", (Throwable)ex);
                    return new StandardResponse(500).error("Unexpected error during data migration: " + ex.getMessage());
                }
            });
        }
    }

    public static class StartDataMigrationRequest
    extends Action.Request {
        public static final String FIELD_ALLOW_YELLOW_INDICES = "allow_yellow_indices";
        private final MigrationConfig config;

        public StartDataMigrationRequest(UnparsedDocument<?> message) throws ConfigValidationException {
            this(message.parseAsDocNode());
        }

        public StartDataMigrationRequest(Action.UnparsedMessage message) throws ConfigValidationException {
            this(message.requiredDocNode());
        }

        private StartDataMigrationRequest(DocNode docNode) throws ConfigValidationException {
            boolean allowYellowDataIndices = Optional.ofNullable(docNode.getBoolean(FIELD_ALLOW_YELLOW_INDICES)).orElse(false);
            this.config = new MigrationConfig(allowYellowDataIndices);
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)FIELD_ALLOW_YELLOW_INDICES, (Object)this.config.allowYellowIndices());
        }

        public MigrationConfig getConfig() {
            return this.config;
        }
    }
}

