/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MappingTypes;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.google.common.base.Throwables;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.elasticsearch.common.time.DateFormatter;

public record StepExecutionSummary(long number, LocalDateTime startTime, String name, StepExecutionStatus status, String message, @Nullable String details) implements Document<StepExecutionSummary>
{
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    public static final String FIELD_START_TIME = "start_time";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_NO = "number";
    public static final String FIELD_DETAILS = "details";
    public static final ImmutableMap<String, Object> MAPPING = ImmutableMap.of((Object)"dynamic", (Object)true, (Object)"properties", (Object)ImmutableMap.of((Object)"start_time", MappingTypes.MAPPING_DATE, (Object)"status", MappingTypes.MAPPING_KEYWORD, (Object)"name", MappingTypes.MAPPING_KEYWORD, (Object)"number", MappingTypes.MAPPING_LONG, (Object)"message", MappingTypes.MAPPING_TEXT_WITH_KEYWORD).with((Object)"details", MappingTypes.MAPPING_TEXT_WITH_KEYWORD));

    public StepExecutionSummary(long number, LocalDateTime startTime, String name, StepExecutionStatus status, String message) {
        this(number, startTime, name, status, message, (String)null);
    }

    public StepExecutionSummary(long number, LocalDateTime startTime, String name, StepExecutionStatus status, String message, Throwable details) {
        this(number, startTime, name, status, message, StepExecutionSummary.stacktraceToString(details));
    }

    public StepExecutionSummary {
        Objects.requireNonNull(startTime, "Start time is required");
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(status, "Step status required");
        Objects.requireNonNull(message, "Message is required");
    }

    StepExecutionSummary(long number, LocalDateTime startTime, String name, StepResult stepResult) {
        this(number, startTime, name, Objects.requireNonNull(stepResult, "Step result is required").status(), stepResult.message(), stepResult.details());
    }

    private static String stacktraceToString(Throwable ex) {
        if (ex == null) {
            return null;
        }
        try {
            return Throwables.getStackTraceAsString((Throwable)ex);
        }
        catch (Throwable e) {
            return "Cannot obtain stack trace from exception " + ex.getClass().getCanonicalName() + " with message " + ex.getMessage();
        }
    }

    public ImmutableMap<String, Object> toBasicObject() {
        String formattedStartTime = DATE_FORMATTER.format((TemporalAccessor)this.startTime);
        return OrderedImmutableMap.ofNonNull((Object)FIELD_NO, (Object)this.number, (Object)FIELD_START_TIME, (Object)formattedStartTime, (Object)FIELD_NAME, (Object)this.name, (Object)FIELD_STATUS, (Object)this.status.name().toLowerCase(), (Object)FIELD_MESSAGE, (Object)this.message).with((Object)FIELD_DETAILS, (Object)this.details);
    }

    public static StepExecutionSummary parse(DocNode docNode) {
        try {
            LocalDateTime startTime = LocalDateTime.from(DATE_FORMATTER.parse(docNode.getAsString(FIELD_START_TIME)));
            StepExecutionStatus status = StepExecutionStatus.valueOf(docNode.getAsString(FIELD_STATUS).toUpperCase());
            return new StepExecutionSummary(docNode.getNumber(FIELD_NO).longValue(), startTime, docNode.getAsString(FIELD_NAME), status, docNode.getAsString(FIELD_MESSAGE), docNode.getAsString(FIELD_DETAILS));
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse step execution summary from json.", e);
        }
    }
}

