/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.TenantAlias;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;

class PopulateTenantsStep
implements MigrationStep {
    public static final String INDEX_VERSION_PATTERN = "_8\\.7\\.\\d+_\\d{3}\\b";
    public static final String ALIAS_VERSION_PATTERN = "_8\\.7\\.\\d+\\b";
    private static final Logger log = LogManager.getLogger(PopulateTenantsStep.class);
    private final FeMultiTenancyConfigurationProvider configurationProvider;
    private final StepRepository repository;

    public PopulateTenantsStep(FeMultiTenancyConfigurationProvider configurationProvider, StepRepository repository) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider, "Multi-tenancy configuration provider is required");
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext dataMigrationContext) {
        ImmutableSet<String> configuredTenants = this.configurationProvider.getTenantNames();
        Optional<FeMultiTenancyConfig> optionalConfig = this.configurationProvider.getConfig();
        return optionalConfig.map(config -> this.executeWithConfig((FeMultiTenancyConfig)config, dataMigrationContext, configuredTenants)).orElse(new StepResult(StepExecutionStatus.MULTI_TENANCY_CONFIG_NOT_AVAILABLE_ERROR, "Cannot load SearchGuard multi tenancy config."));
    }

    private StepResult executeWithConfig(FeMultiTenancyConfig config, DataMigrationContext context, ImmutableSet<String> configuredTenants) {
        log.debug("Searching for tenants, provided configuration '{}' and tenant names '{}'.", (Object)config, configuredTenants);
        List configuredTenantAliases = configuredTenants.stream().filter(name -> !"SGS_GLOBAL_TENANT".equals(name)).sorted().map(name -> new TenantAlias(this.toInternalIndexName(config, (String)name), (String)name)).collect(Collectors.toList());
        GetIndexResponse allExistingIndices = this.repository.findAllIndicesIncludingHidden();
        log.debug("Tenants found in configuration '{}'.", configuredTenantAliases);
        List<TenantAlias> globalTenantIndexName = PopulateTenantsStep.extractGlobalTenantIndexName(config.getIndex(), allExistingIndices);
        List tenants = Stream.concat(globalTenantIndexName.stream(), configuredTenantAliases.stream()).map(this::resolveIndexAlias).flatMap(Optional::stream).collect(Collectors.toList());
        log.debug("Tenants read from configuration with index names resolved: '{}'", tenants);
        Set tenantIndices = tenants.stream().map(TenantIndex::indexName).collect(Collectors.toSet());
        if (tenants.isEmpty()) {
            return new StepResult(StepExecutionStatus.INDICES_NOT_FOUND_ERROR, "Indices related to front-end multi tenancy not found.");
        }
        List<TenantIndex> globalTenants = tenants.stream().filter(TenantIndex::belongsToGlobalTenant).toList();
        if (globalTenants.size() != 1) {
            String message = "Definition of exactly one global tenant is expected, but found '" + globalTenants.size() + "'. Please verify that index '" + String.valueOf(globalTenantIndexName) + "' exists.";
            String globalTenantsString = globalTenants.stream().map(Object::toString).collect(Collectors.joining(", "));
            return new StepResult(StepExecutionStatus.GLOBAL_TENANT_NOT_FOUND_ERROR, message, "List of global tenants: " + globalTenantsString);
        }
        String globalTenantIndexVersion = globalTenants.get(0).getVersion();
        tenants = tenants.stream().filter(tenantIndex -> tenantIndex.isInVersion(globalTenantIndexVersion)).collect(Collectors.toList());
        context.setTenantIndices((ImmutableList<TenantIndex>)ImmutableList.of(tenants));
        String stringTenantList = tenants.stream().map(data -> "tenant " + (data.belongsToUserPrivateTenant() ? "__user__" : data.tenantName()) + " -> " + data.indexName()).collect(Collectors.joining(", "));
        String details = "Tenants found for migration: " + stringTenantList;
        String message = "Populates " + tenants.size() + " tenants' data for migration";
        return new StepResult(StepExecutionStatus.OK, message, details);
    }

    private static List<TenantAlias> extractGlobalTenantIndexName(String configuredFrontendIndexName, GetIndexResponse allExistingIndices) {
        Pattern globalTenantIndexNamePattern = Pattern.compile(Pattern.quote(configuredFrontendIndexName) + INDEX_VERSION_PATTERN);
        Pattern globalTenantAliasNamePattern = Pattern.compile(Pattern.quote(configuredFrontendIndexName) + ALIAS_VERSION_PATTERN);
        return allExistingIndices.aliases().entrySet().stream().filter(entry -> globalTenantIndexNamePattern.matcher((CharSequence)entry.getKey()).matches()).filter(entry -> ((List)entry.getValue()).stream().map(AliasMetadata::getAlias).collect(Collectors.toSet()).contains(configuredFrontendIndexName)).filter(entry -> ((List)entry.getValue()).stream().map(AliasMetadata::getAlias).anyMatch(alias -> globalTenantAliasNamePattern.matcher((CharSequence)alias).matches())).map(Map.Entry::getKey).map(indexName -> new TenantAlias((String)indexName, "SGS_GLOBAL_TENANT")).toList();
    }

    private Optional<TenantIndex> resolveIndexAlias(TenantAlias tenantAlias) {
        return this.getIndexNameByAliasName(tenantAlias.aliasName()).map(indexName -> new TenantIndex((String)indexName, tenantAlias.tenantName()));
    }

    @Override
    public String name() {
        return "Populate tenants";
    }

    private String toInternalIndexName(FeMultiTenancyConfig config, String tenant) {
        if (tenant == null) {
            throw new ElasticsearchException("tenant must not be null here", new Object[0]);
        }
        String tenantInfoPart = "_" + TenantManager.toInternalTenantName((String)tenant);
        String prefix = config.getIndex();
        StringBuilder result = new StringBuilder(prefix).append(tenantInfoPart);
        return result.toString();
    }

    private Optional<String> getIndexNameByAliasName(String aliasName) {
        Optional<GetIndexResponse> indexResponse = this.repository.findIndexByNameOrAlias(aliasName);
        if (indexResponse.isEmpty()) {
            log.warn("Index '{}' with front-end data does not exist, its data will be not used during migration.", (Object)aliasName);
        }
        return indexResponse.map(response -> {
            String[] indices = response.getIndices();
            if (indices == null || indices.length != 1) {
                String message = "Alias " + aliasName + " should be associated with exactly one index";
                String details = "Alias " + aliasName + " is associated with indices " + Optional.ofNullable(indices).stream().flatMap(Arrays::stream).map(indexName -> "'" + indexName + "'").collect(Collectors.joining(", "));
                throw new StepException(message, StepExecutionStatus.CANNOT_RESOLVE_INDEX_BY_ALIAS_ERROR, details);
            }
            String indexName2 = indices[0];
            log.debug("Alias '{}' is related to index '{}'.", (Object)aliasName, (Object)indexName2);
            return indexName2;
        });
    }
}

