/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.GetMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class GetRequestHandler
extends RequestHandler<GetRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final GetMapper getMapper;

    public GetRequestHandler(Client nodeClient, ThreadContext threadContext, GetMapper getMapper) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.getMapper = Objects.requireNonNull(getMapper, "getMapper is required");
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, GetRequest request, ActionListener<?> listener) {
        this.log.debug("Handle get request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            GetRequest scoped = this.getMapper.toScopedGetRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<GetResponse> listenerWrapper = new TenantScopedActionListenerWrapper<GetResponse>(listener, storedContext, this.getMapper);
            this.nodeClient.get(scoped, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

