/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.searchguard.enterprise.femt.tenants.AvailableTenantService;
import com.floragunn.searchguard.enterprise.femt.tenants.DefaultTenantNotFoundException;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.injection.guice.Inject;

public class GetAvailableTenantsAction
extends Action<StandardRequests.EmptyRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(GetAvailableTenantsAction.class);
    public static final String NAME = "cluster:admin:searchguard:femt:user/available_tenants/get";
    public static final GetAvailableTenantsAction INSTANCE = new GetAvailableTenantsAction();

    public GetAvailableTenantsAction() {
        super(NAME, StandardRequests.EmptyRequest::new, StandardResponse::new);
    }

    public static class GetAvailableTenantsHandler
    extends Action.Handler<StandardRequests.EmptyRequest, StandardResponse> {
        private final AvailableTenantService availableTenantService;

        @Inject
        public GetAvailableTenantsHandler(Action.HandlerDependencies handlerDependencies, AvailableTenantService availableTenantService) {
            super((Action)INSTANCE, handlerDependencies);
            this.availableTenantService = Objects.requireNonNull(availableTenantService, "Available tenant service is required");
        }

        protected CompletableFuture<StandardResponse> doExecute(StandardRequests.EmptyRequest request) {
            return this.supplyAsync(() -> {
                try {
                    return this.availableTenantService.findTenantAvailableForCurrentUser().map(availableTenantData -> new StandardResponse(200).data(availableTenantData)).orElseGet(() -> new StandardResponse(404, "User not found"));
                }
                catch (DefaultTenantNotFoundException ex) {
                    String message = "Cannot determine default tenant for current user";
                    log.error(message, (Throwable)((Object)ex));
                    return new StandardResponse(ex.status().getStatus(), message);
                }
                catch (Exception ex) {
                    String message = "Cannot retrieve information about tenants available for current user.";
                    log.error(message, (Throwable)ex);
                    return new StandardResponse(500, message);
                }
            });
        }
    }
}

