/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantRepository;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultitenancyActivationService {
    private static final Logger log = LogManager.getLogger(MultitenancyActivationService.class);
    private final TenantRepository tenantRepository;
    private final ConfigurationRepository configurationRepository;
    private final FeMultiTenancyConfigurationProvider configProvider;

    public MultitenancyActivationService(TenantRepository tenantRepository, ConfigurationRepository configurationRepository, FeMultiTenancyConfigurationProvider configProvider) {
        this.tenantRepository = Objects.requireNonNull(tenantRepository, "Tenant repository is required");
        this.configurationRepository = Objects.requireNonNull(configurationRepository, "Configuration repository is required");
        this.configProvider = Objects.requireNonNull(configProvider, "Multitenancy configuration provider is required");
    }

    public StandardResponse activate() throws StepException {
        this.tenantRepository.extendTenantsIndexMappings(MultitenancyActivationService.getSgTenantFieldMapping());
        FeMultiTenancyConfig configuration = this.configProvider.getConfig().orElse(FeMultiTenancyConfig.DEFAULT);
        if (configuration.isEnabled()) {
            return new StandardResponse(200, "Multitenancy is already enabled, nothing to be done");
        }
        return this.enableMultitenancy(configuration);
    }

    public static DocNode getSgTenantFieldMapping() {
        return DocNode.of((String)RequestResponseTenantData.getSgTenantField(), (Object)DocNode.of((String)"type", (Object)"keyword"));
    }

    private StandardResponse enableMultitenancy(FeMultiTenancyConfig configuration) {
        StandardResponse standardResponse;
        block8: {
            FeMultiTenancyConfig newConfig = configuration.withEnabled(true);
            SgDynamicConfiguration config = SgDynamicConfiguration.of(FeMultiTenancyConfig.TYPE, (String)"default", (Object)newConfig);
            try {
                this.configurationRepository.update(FeMultiTenancyConfig.TYPE, config, null, false);
                log.info("Multitenancy has been activated");
                standardResponse = new StandardResponse(200, "Multitenancy has been enabled");
                if (config == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (config != null) {
                        try {
                            config.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ConfigValidationException | ConcurrentConfigUpdateException | ConfigUpdateException e) {
                    log.error("Cannot enable multitenancy", e);
                    String message = "Cannot enable multitenancy, unexpected error occurred " + e.getMessage();
                    return new StandardResponse(500, message);
                }
            }
            config.close();
        }
        return standardResponse;
    }
}

