/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.threadpool.ThreadPool;

public class AuthInfoService {
    private final ThreadPool threadPool;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;
    private final AdminDNs adminDNs;

    public AuthInfoService(ThreadPool threadPool, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, AdminDNs adminDNs) {
        this.threadPool = threadPool;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
        this.adminDNs = adminDNs;
    }

    public User getCurrentUser() {
        User user = this.peekCurrentUser();
        if (user == null) {
            throw new ElasticsearchSecurityException("No user information available", new Object[0]);
        }
        return user;
    }

    public User peekCurrentUser() {
        return (User)this.threadPool.getThreadContext().getTransient("_sg_user");
    }

    public boolean isCurrentUserAdmin() {
        return this.isAdmin(this.peekCurrentUser());
    }

    public boolean isAdmin(User user) {
        if (user != null) {
            return this.adminDNs.isAdmin(user);
        }
        return false;
    }

    public TransportAddress getCurrentRemoteAddress() {
        return (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
    }

    public SpecialPrivilegesEvaluationContext getSpecialPrivilegesEvaluationContext() {
        return this.specialPrivilegesEvaluationContextProviderRegistry.provide(this.getCurrentUser(), this.threadPool.getThreadContext());
    }
}

