/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.base.AuthcResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AuthenticationDebugLogger {
    public static final AuthenticationDebugLogger DISABLED = new AuthenticationDebugLogger(){

        @Override
        void add(String authcMethod, boolean success, String message) {
        }

        @Override
        void add(String authcMethod, boolean success, String message, ImmutableMap<String, Object> details) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public ImmutableList<AuthcResult.DebugInfo> get() {
            return ImmutableList.empty();
        }

        @Override
        public void add(AuthcResult.DebugInfo debugInfo) {
        }
    };

    public static AuthenticationDebugLogger create(boolean enabled) {
        if (enabled) {
            return new Active();
        }
        return DISABLED;
    }

    public abstract ImmutableList<AuthcResult.DebugInfo> get();

    abstract void add(String var1, boolean var2, String var3);

    abstract void add(String var1, boolean var2, String var3, ImmutableMap<String, Object> var4);

    public abstract void add(AuthcResult.DebugInfo var1);

    public abstract boolean isEnabled();

    public void success(String authcMethod, String message) {
        this.add(authcMethod, true, message);
    }

    public void success(String authcMethod, String message, ImmutableMap<String, Object> details) {
        this.add(authcMethod, true, message, details);
    }

    public void failure(String authcMethod, String message) {
        this.add(authcMethod, false, message);
    }

    public void failure(String authcMethod, String message, ImmutableMap<String, Object> details) {
        this.add(authcMethod, false, message, details);
    }

    public void success(String authcMethod, String message, String detail1key, Object detail1value) {
        if (this.isEnabled()) {
            this.success(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value));
        }
    }

    public void success(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value) {
        if (this.isEnabled()) {
            this.success(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value));
        }
    }

    public void success(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value) {
        if (this.isEnabled()) {
            this.success(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value));
        }
    }

    public void success(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value, String detail4key, Object detail4value) {
        if (this.isEnabled()) {
            this.success(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value, (Object)detail4key, (Object)detail4value));
        }
    }

    public void success(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value, String detail4key, Object detail4value, String detail5key, Object detail5value) {
        if (this.isEnabled()) {
            this.success(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value, (Object)detail4key, (Object)detail4value, (Object)detail5key, (Object)detail5value));
        }
    }

    public void failure(String authcMethod, String message, String detail1key, Object detail1value) {
        if (this.isEnabled()) {
            this.failure(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value));
        }
    }

    public void failure(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value) {
        if (this.isEnabled()) {
            this.failure(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value));
        }
    }

    public void failure(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value) {
        if (this.isEnabled()) {
            this.failure(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value));
        }
    }

    public void failure(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value, String detail4key, Object detail4value) {
        if (this.isEnabled()) {
            this.failure(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value, (Object)detail4key, (Object)detail4value));
        }
    }

    public void failure(String authcMethod, String message, String detail1key, Object detail1value, String detail2key, Object detail2value, String detail3key, Object detail3value, String detail4key, Object detail4value, String detail5key, Object detail5value) {
        if (this.isEnabled()) {
            this.failure(authcMethod, message, (ImmutableMap<String, Object>)ImmutableMap.of((Object)detail1key, (Object)detail1value, (Object)detail2key, (Object)detail2value, (Object)detail3key, (Object)detail3value, (Object)detail4key, (Object)detail4value, (Object)detail5key, (Object)detail5value));
        }
    }

    public void add(String authcMethod, AuthcResult.DebugInfo debugInfo) {
        this.add(new AuthcResult.DebugInfo(authcMethod, debugInfo.isSuccess(), debugInfo.getMessage(), debugInfo.getDetails()));
    }

    public static class Active
    extends AuthenticationDebugLogger {
        private final List<AuthcResult.DebugInfo> list = new ArrayList<AuthcResult.DebugInfo>();

        @Override
        void add(String authcMethod, boolean success, String message) {
            this.list.add(new AuthcResult.DebugInfo(authcMethod, success, message));
        }

        @Override
        void add(String authcMethod, boolean success, String message, ImmutableMap<String, Object> details) {
            this.list.add(new AuthcResult.DebugInfo(authcMethod, success, message, (Map<String, Object>)details));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public ImmutableList<AuthcResult.DebugInfo> get() {
            return ImmutableList.of(this.list);
        }

        @Override
        public void add(AuthcResult.DebugInfo debugInfo) {
            this.list.add(debugInfo);
        }
    }
}

