/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest.authenticators;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicAuthenticationFrontend
implements HttpAuthenticationFrontend,
ApiAuthenticationFrontend {
    public static String TYPE = "basic";
    private static final Logger log = LogManager.getLogger(BasicAuthenticationFrontend.class);
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", TYPE).initialized();
    private final boolean challenge;

    public BasicAuthenticationFrontend(DocNode docNode, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, (Parser.Context)context);
        this.challenge = vNode.get("challenge").withDefault(true).asBoolean();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public AuthCredentials extractCredentials(RequestMetaData<?> request) {
        AuthCredentials.Builder credsBuilder = this.decodeBasicCredentials(request.getAuthorizationByScheme("basic"));
        if (credsBuilder != null) {
            return credsBuilder.authenticatorType(this.getType()).build();
        }
        return null;
    }

    @Override
    public AuthCredentials extractCredentials(Map<String, Object> request) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        if (request.get("user") == null) {
            validationErrors.add((ValidationError)new MissingAttribute("user", null));
        }
        if (request.get("password") == null) {
            validationErrors.add((ValidationError)new MissingAttribute("password", null));
        }
        validationErrors.throwExceptionForPresentErrors();
        return AuthCredentials.forUser(String.valueOf(request.get("user"))).password(String.valueOf(request.get("password")).getBytes(StandardCharsets.UTF_8)).complete().build();
    }

    @Override
    public String getChallenge(AuthCredentials credentials) {
        if (this.challenge) {
            return "Basic realm=\"Search Guard\"";
        }
        return null;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private AuthCredentials.Builder decodeBasicCredentials(String basicAuthorization) {
        if (basicAuthorization == null) {
            return null;
        }
        String decodedBasicHeader = new String(Base64.getDecoder().decode(basicAuthorization), StandardCharsets.UTF_8);
        int firstColonIndex = decodedBasicHeader.indexOf(58);
        if (firstColonIndex == -1) {
            log.debug("Invalid 'Authorization' header; no colon found.");
            return null;
        }
        String username = decodedBasicHeader.substring(0, firstColonIndex);
        String password = decodedBasicHeader.length() - 1 != firstColonIndex ? decodedBasicHeader.substring(firstColonIndex + 1) : "";
        return AuthCredentials.forUser(username).password(password.getBytes(StandardCharsets.UTF_8)).complete();
    }
}

