/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.FrontendAuthcConfig;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class MergedAuthcConfig {
    private final SgDynamicConfiguration<FrontendAuthcConfig> frontendConfig;
    private final RestAuthcConfig authcConfig;
    private final ImmutableMap<String, ImmutableList<AuthenticationDomain<ApiAuthenticationFrontend>>> configNameToAuthenticationDomainMap;

    public MergedAuthcConfig(SgDynamicConfiguration<FrontendAuthcConfig> frontendConfig, RestAuthcConfig authcConfig) {
        this.frontendConfig = frontendConfig;
        this.authcConfig = authcConfig;
        this.configNameToAuthenticationDomainMap = this.createDomainMap(frontendConfig, authcConfig);
    }

    ImmutableList<AuthenticationDomain<ApiAuthenticationFrontend>> get(String config) {
        return (ImmutableList)this.configNameToAuthenticationDomainMap.get((Object)config);
    }

    boolean isDebugEnabled(String config) {
        if (this.authcConfig != null && this.authcConfig.isDebugEnabled()) {
            return true;
        }
        FrontendAuthcConfig frontendConfig = this.frontendConfig.getCEntry(config);
        if (frontendConfig != null) {
            return frontendConfig.isDebug();
        }
        return false;
    }

    private List<AuthenticationDomain<ApiAuthenticationFrontend>> getApiAuthenticationDomains(RestAuthcConfig authcConfig) {
        if (authcConfig == null) {
            return ImmutableList.empty();
        }
        ArrayList<AuthenticationDomain<ApiAuthenticationFrontend>> result = new ArrayList<AuthenticationDomain<ApiAuthenticationFrontend>>(authcConfig.getAuthenticators().size());
        for (AuthenticationDomain domain : authcConfig.getAuthenticators()) {
            if (!(domain.getFrontend() instanceof ApiAuthenticationFrontend) || !domain.isEnabled()) continue;
            AuthenticationDomain apiAuthenticationDomain = domain;
            result.add(apiAuthenticationDomain);
        }
        return result;
    }

    private ImmutableMap<String, ImmutableList<AuthenticationDomain<ApiAuthenticationFrontend>>> createDomainMap(SgDynamicConfiguration<FrontendAuthcConfig> frontendConfig, RestAuthcConfig authczConfig) {
        List<AuthenticationDomain<ApiAuthenticationFrontend>> globalDomains = this.getApiAuthenticationDomains(authczConfig);
        if (frontendConfig.getCEntries().isEmpty()) {
            return ImmutableMap.of((Object)"default", (Object)ImmutableList.of(globalDomains));
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder(frontendConfig.getCEntries().size());
        for (Map.Entry entry : frontendConfig.getCEntries().entrySet()) {
            result.with((Object)((String)entry.getKey()), (Object)ImmutableList.concat(globalDomains, (Collection)((FrontendAuthcConfig)entry.getValue()).getAuthDomains().map(a -> a.getAuthenticationDomain())));
        }
        return result.build();
    }

    public String toString() {
        return this.configNameToAuthenticationDomainMap.keySet().toString();
    }

    Collection<AuthenticationDomain<ApiAuthenticationFrontend>> getAuthenticationDomains() {
        return this.configNameToAuthenticationDomainMap.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
    }
}

