/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.CheckTable;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchsupport.meta.Meta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.rest.RestStatus;

public class PrivilegesEvaluationResult {
    public static final PrivilegesEvaluationResult OK = new PrivilegesEvaluationResult(Status.OK);
    public static final PrivilegesEvaluationResult PARTIALLY_OK = new PrivilegesEvaluationResult(Status.PARTIALLY_OK);
    public static final PrivilegesEvaluationResult OK_WHEN_RESOLVED = new PrivilegesEvaluationResult(Status.OK_WHEN_RESOLVED);
    public static final PrivilegesEvaluationResult EMPTY = new PrivilegesEvaluationResult(Status.EMPTY);
    public static final PrivilegesEvaluationResult INSUFFICIENT = new PrivilegesEvaluationResult(Status.INSUFFICIENT);
    public static final PrivilegesEvaluationResult PENDING = new PrivilegesEvaluationResult(Status.PENDING);
    private final Status status;
    private final CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable;
    private final ImmutableList<Error> errors;
    private final ImmutableSet<String> availableIndices;
    private final ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>> additionalAvailableIndices;
    private final ImmutableMap<Action.AdditionalDimension, CheckTable<Meta.IndexLikeObject, Action>> additionalIndexToActionPrivilegeTables;
    private final String reason;
    private final ImmutableList<ActionFilter> additionalActionFilters;

    PrivilegesEvaluationResult(Status status) {
        this.status = status;
        this.indexToActionPrivilegeTable = null;
        this.errors = ImmutableList.empty();
        this.reason = null;
        this.availableIndices = null;
        this.additionalActionFilters = ImmutableList.empty();
        this.additionalAvailableIndices = ImmutableMap.empty();
        this.additionalIndexToActionPrivilegeTables = ImmutableMap.empty();
    }

    PrivilegesEvaluationResult(Status status, String reason, ImmutableSet<String> availableIndices, ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>> additionalAvailableIndices, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable, ImmutableMap<Action.AdditionalDimension, CheckTable<Meta.IndexLikeObject, Action>> additionalIndexToActionPrivilegeTables, ImmutableList<Error> errors, ImmutableList<ActionFilter> additionalActionFilters) {
        this.status = status;
        this.indexToActionPrivilegeTable = indexToActionPrivilegeTable;
        this.errors = errors;
        this.reason = reason;
        this.availableIndices = availableIndices;
        this.additionalAvailableIndices = additionalAvailableIndices != null ? additionalAvailableIndices : ImmutableMap.empty();
        this.additionalIndexToActionPrivilegeTables = additionalIndexToActionPrivilegeTables != null ? additionalIndexToActionPrivilegeTables : ImmutableMap.empty();
        this.additionalActionFilters = additionalActionFilters;
    }

    public PrivilegesEvaluationResult reason(String reason) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult reason(String reason, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult reason(String reason, Error error) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, (ImmutableList<Error>)ImmutableList.of(this.errors), this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.additionalAvailableIndices, indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.additionalAvailableIndices, indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(String reason, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.additionalAvailableIndices, indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(ImmutableList<Error> errors) {
        if (errors.size() != 0) {
            return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, errors, this.additionalActionFilters);
        }
        return this;
    }

    public PrivilegesEvaluationResult with(ActionFilter additionalActionFilter) {
        if (additionalActionFilter != null) {
            return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, this.errors, (ImmutableList<ActionFilter>)this.additionalActionFilters.with((Object)additionalActionFilter));
        }
        return this;
    }

    public PrivilegesEvaluationResult availableIndices(ImmutableSet<Meta.IndexLikeObject> availableIndices, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, this.reason, (ImmutableSet<String>)availableIndices.map(Meta.IndexLikeObject::name), this.additionalAvailableIndices, indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult availableIndices(ImmutableSet<Meta.IndexLikeObject> availableIndices, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable) {
        return new PrivilegesEvaluationResult(this.status, this.reason, (ImmutableSet<String>)availableIndices.map(Meta.IndexLikeObject::name), this.additionalAvailableIndices, indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult availableAdditionally(Action.AdditionalDimension role, ImmutableSet<String> addtionalAvailableIndices, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, (ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>>)this.additionalAvailableIndices.with((Object)role, addtionalAvailableIndices), this.indexToActionPrivilegeTable, (ImmutableMap<Action.AdditionalDimension, CheckTable<Meta.IndexLikeObject, Action>>)this.additionalIndexToActionPrivilegeTables.with((Object)role, indexToActionPrivilegeTable), errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult availableAdditionally(Action.AdditionalDimension role, ImmutableSet<String> addtionalAvailableIndices, CheckTable<Meta.IndexLikeObject, Action> indexToActionPrivilegeTable) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, (ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>>)this.additionalAvailableIndices.with((Object)role, addtionalAvailableIndices), this.indexToActionPrivilegeTable, (ImmutableMap<Action.AdditionalDimension, CheckTable<Meta.IndexLikeObject, Action>>)this.additionalIndexToActionPrivilegeTables.with((Object)role, indexToActionPrivilegeTable), this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult withAdditional(Action.AdditionalDimension role, PrivilegesEvaluationResult additional) {
        Status status = this.status != additional.status ? (additional.status == Status.INSUFFICIENT || this.status == Status.INSUFFICIENT ? Status.INSUFFICIENT : (additional.status == Status.PENDING || this.status == Status.PENDING ? Status.PENDING : (additional.status == Status.EMPTY || this.status == Status.EMPTY ? Status.EMPTY : (additional.status == Status.OK_WHEN_RESOLVED ? (this.status == Status.OK || this.status == Status.OK_WHEN_RESOLVED ? Status.OK_WHEN_RESOLVED : this.status) : (additional.status == Status.PARTIALLY_OK ? (this.status == Status.OK || this.status == Status.OK_WHEN_RESOLVED || this.status == Status.PARTIALLY_OK ? Status.PARTIALLY_OK : this.status) : this.status))))) : this.status;
        Object reason = this.reason;
        if (reason == null) {
            reason = additional.reason;
        } else if (additional.reason != null) {
            reason = this.reason + "\n" + additional.reason;
        }
        return new PrivilegesEvaluationResult(status, (String)reason, this.availableIndices, (ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>>)(additional.availableIndices != null ? this.additionalAvailableIndices.with((Object)role, additional.availableIndices) : this.additionalAvailableIndices), this.indexToActionPrivilegeTable, (ImmutableMap<Action.AdditionalDimension, CheckTable<Meta.IndexLikeObject, Action>>)(additional.indexToActionPrivilegeTable != null ? this.additionalIndexToActionPrivilegeTables.with((Object)role, additional.indexToActionPrivilegeTable) : this.additionalIndexToActionPrivilegeTables), (ImmutableList<Error>)this.errors.with(additional.errors), (ImmutableList<ActionFilter>)this.additionalActionFilters.with(additional.additionalActionFilters));
    }

    public PrivilegesEvaluationResult missingPrivileges(Action action) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.additionalAvailableIndices, (CheckTable<Meta.IndexLikeObject, Action>)CheckTable.create((Object)Meta.NonExistent.BLANK, (Set)ImmutableSet.of((Object)action)), this.additionalIndexToActionPrivilegeTables, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult status(Status status) {
        return new PrivilegesEvaluationResult(status, this.reason, this.availableIndices, this.additionalAvailableIndices, this.indexToActionPrivilegeTable, this.additionalIndexToActionPrivilegeTables, this.errors, this.additionalActionFilters);
    }

    public CheckTable<Meta.IndexLikeObject, Action> getIndexToActionPrivilegeTable() {
        return this.indexToActionPrivilegeTable;
    }

    public ImmutableList<Error> getErrors() {
        return this.errors;
    }

    public Throwable getFirstThrowable() {
        if (this.errors.isEmpty()) {
            return null;
        }
        for (Error error : this.errors) {
            if (error.cause == null) continue;
            return error.cause;
        }
        return null;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public ImmutableSet<String> getAvailableIndices() {
        return this.availableIndices;
    }

    public String toString() {
        try {
            StringBuilder result = new StringBuilder("");
            result.append("Status: ").append((Object)this.status).append("\n");
            if (this.reason != null) {
                result.append("Reason: ").append(this.reason).append("\n");
            }
            if (this.indexToActionPrivilegeTable != null) {
                String evaluatedPrivileges = this.indexToActionPrivilegeTable.toString("ok", "MISSING");
                if (evaluatedPrivileges.length() > 30 || evaluatedPrivileges.contains("\n")) {
                    result.append("Evaluated privileges:\n").append(evaluatedPrivileges).append("\n");
                } else {
                    result.append("Evaluated privileges: ").append(evaluatedPrivileges).append("\n");
                }
            }
            if (!this.additionalIndexToActionPrivilegeTables.isEmpty()) {
                for (Map.Entry entry : this.additionalIndexToActionPrivilegeTables.entrySet()) {
                    String evaluatedPrivileges = ((CheckTable)entry.getValue()).toString("ok", "MISSING");
                    if (evaluatedPrivileges.length() > 30 || evaluatedPrivileges.contains("\n")) {
                        result.append("Evaluated privileges for ").append(entry.getKey()).append(":\n").append(evaluatedPrivileges).append("\n");
                        continue;
                    }
                    result.append("Evaluated privileges for ").append(entry.getKey()).append(": ").append(evaluatedPrivileges).append("\n");
                }
            }
            if (this.errors.size() == 1) {
                result.append("Errors: ").append(this.errors.only());
            } else if (this.errors.size() > 1) {
                result.append("Errors:\n").append(this.errors.stream().map(e -> " - " + String.valueOf(e) + "\n").collect(Collectors.toList())).append("\n");
            }
            return result.toString();
        }
        catch (RuntimeException e2) {
            throw new RuntimeException(e2);
        }
    }

    public ImmutableList<ActionFilter> getAdditionalActionFilters() {
        return this.additionalActionFilters;
    }

    public boolean hasAdditionalActionFilters() {
        return this.additionalActionFilters != null && this.additionalActionFilters.size() > 0;
    }

    public Exception toSecurityException(PrivilegesEvaluationContext context) {
        ElasticsearchSecurityException result = new ElasticsearchSecurityException("Insufficient permissions", RestStatus.FORBIDDEN, new Object[0]);
        if (context.isDebugEnabled()) {
            if (this.indexToActionPrivilegeTable != null) {
                if (!this.isRelatedToIndexPermission()) {
                    result.addMetadata("es.missing_permissions", this.indexToActionPrivilegeTable.getColumns().stream().map(a -> a.name()).collect(Collectors.toList()));
                } else {
                    result.addMetadata("es.missing_permissions", this.getFlattenedIndexToActionPrivilegeTable());
                }
            }
            if (this.reason != null) {
                result.addMetadata("es.reason_detail", new String[]{this.reason});
            }
            result.addMetadata("es.user", new String[]{String.valueOf(context.getUser())});
            if (context.getMappedRoles() != null) {
                result.addMetadata("es.effective_roles", context.getMappedRoles().stream().collect(Collectors.toList()));
            }
            result.addMetadata("es.user_attributes", context.getUser().getStructuredAttributes().keySet().stream().collect(Collectors.toList()));
            if (this.errors != null && !this.errors.isEmpty()) {
                result.addMetadata("es.errors", this.errors.stream().map(e -> e.toString()).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private boolean isRelatedToIndexPermission() {
        return this.indexToActionPrivilegeTable != null && !this.indexToActionPrivilegeTable.isEmpty() && ((Action)this.indexToActionPrivilegeTable.getColumns().any()).isIndexLikePrivilege();
    }

    private List<String> getFlattenedIndexToActionPrivilegeTable() {
        ArrayList<String> result = new ArrayList<String>();
        for (Meta.IndexLikeObject index : this.indexToActionPrivilegeTable.getRows()) {
            for (Action action : this.indexToActionPrivilegeTable.getColumns()) {
                if (this.indexToActionPrivilegeTable.isChecked((Object)index, (Object)action)) continue;
                result.add(String.valueOf(index) + ": " + String.valueOf(action));
            }
        }
        return result;
    }

    public ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>> getAdditionalAvailableIndices() {
        return this.additionalAvailableIndices;
    }

    public static enum Status {
        OK,
        PARTIALLY_OK,
        OK_WHEN_RESOLVED,
        EMPTY,
        INSUFFICIENT,
        PENDING;

    }

    public static class Error {
        private final String message;
        private final Throwable cause;
        private final String role;
        private final Throwable rootCause;

        public Error(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
            this.role = null;
            this.rootCause = Error.getRootCause(cause);
        }

        public Error(String message, Throwable cause, String role) {
            this.message = message;
            this.cause = cause;
            this.role = role;
            this.rootCause = Error.getRootCause(cause);
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            if (this.rootCause != null) {
                return this.message + " [" + String.valueOf(this.rootCause) + "]";
            }
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Error)) {
                return false;
            }
            Error other = (Error)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String getRole() {
            return this.role;
        }

        private static Throwable getRootCause(Throwable t) {
            if (t == null) {
                return null;
            }
            for (int i = 0; t.getCause() != null && t.getCause() != t && i < 10; t = t.getCause(), ++i) {
            }
            return t;
        }
    }
}

