/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchsupport.meta.Meta;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;

public interface Action {
    public String name();

    public boolean isIndexLikePrivilege();

    public boolean isClusterPrivilege();

    public boolean isTenantPrivilege();

    public boolean isOpen();

    public Scope scope();

    public ImmutableSet<Action> getAdditionalPrivileges(ActionRequest var1);

    public ImmutableSet<Action> expandPrivileges(ActionRequest var1);

    public boolean requiresSpecialProcessing();

    public Meta.Alias.ResolutionMode aliasResolutionMode();

    public ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling();

    public ImmutableSet<AdditionalDimension> additionalDimensions();

    public <RequestType extends ActionRequest> WellKnownAction<RequestType, ?, ?> wellKnown(RequestType var1);

    public static class AdditionalDimension {
        public static final AdditionalDimension ALIASES = new AdditionalDimension("aliases", Scope.ALIAS);
        public static final AdditionalDimension RESIZE_TARGET = new AdditionalDimension("resize_target", Scope.INDEX, (ImmutableSet<String>)ImmutableSet.ofArray((Object[])new String[]{"indices:admin/create"}));
        public static final AdditionalDimension DOWNSAMPLE_TARGET = new AdditionalDimension("downsample_target", Scope.INDEX, (ImmutableSet<String>)ImmutableSet.ofArray((Object[])new String[]{"indices:admin/create"}));
        public static final AdditionalDimension MANAGE_ALIASES = new AdditionalDimension("manage_aliases", Scope.ALIAS, (ImmutableSet<String>)ImmutableSet.ofArray((Object[])new String[]{"indices:admin/aliases"}));
        public static final AdditionalDimension DELETE_INDEX = new AdditionalDimension("delete_index", Scope.INDEX_LIKE, (ImmutableSet<String>)ImmutableSet.ofArray((Object[])new String[]{"indices:admin/delete"}));
        private final String id;
        private final ImmutableSet<String> requiredPrivileges;
        private final Scope scope;

        public AdditionalDimension(String id, Scope scope) {
            this.id = id;
            this.scope = scope;
            this.requiredPrivileges = null;
        }

        public AdditionalDimension(String id, Scope scope, ImmutableSet<String> requiredPrivileges) {
            this.id = id;
            this.scope = scope;
            this.requiredPrivileges = requiredPrivileges;
        }

        public ImmutableSet<Action> getRequiredPrivileges(ImmutableSet<Action> original, Actions actions) {
            if (this.requiredPrivileges == null) {
                return original;
            }
            return this.requiredPrivileges.map(a -> actions.get((String)a));
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdditionalDimension)) {
                return false;
            }
            return ((AdditionalDimension)other).id.equals(this.id);
        }

        public String toString() {
            return this.id;
        }

        public Scope scope() {
            return this.scope;
        }
    }

    public static class OtherAction
    implements Action {
        private final String actionName;
        private final Scope scope;

        public OtherAction(String actionName, Scope scope) {
            this.actionName = actionName;
            this.scope = scope;
        }

        @Override
        public String name() {
            return this.actionName;
        }

        public Scope getScope() {
            return this.scope;
        }

        @Override
        public boolean isIndexLikePrivilege() {
            return this.scope.canReferToIndexLikeObjects;
        }

        @Override
        public boolean isClusterPrivilege() {
            return this.scope == Scope.CLUSTER;
        }

        @Override
        public boolean isTenantPrivilege() {
            return this.scope == Scope.TENANT;
        }

        @Override
        public boolean isOpen() {
            return this.scope == Scope.OPEN;
        }

        @Override
        public ImmutableSet<Action> getAdditionalPrivileges(ActionRequest request) {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Action> expandPrivileges(ActionRequest request) {
            return ImmutableSet.of((Object)this);
        }

        @Override
        public boolean requiresSpecialProcessing() {
            return false;
        }

        public String toString() {
            return this.actionName;
        }

        public int hashCode() {
            return this.actionName.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof OtherAction)) {
                return false;
            }
            OtherAction otherAction = (OtherAction)other;
            return this.actionName.equals(otherAction.actionName);
        }

        @Override
        public ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling() {
            return ActionAuthorization.AliasDataStreamHandling.RESOLVE_IF_NECESSARY;
        }

        @Override
        public Meta.Alias.ResolutionMode aliasResolutionMode() {
            return Meta.Alias.ResolutionMode.NORMAL;
        }

        @Override
        public Scope scope() {
            return this.scope;
        }

        @Override
        public <RequestType extends ActionRequest> WellKnownAction<RequestType, ?, ?> wellKnown(RequestType request) {
            return null;
        }

        @Override
        public ImmutableSet<AdditionalDimension> additionalDimensions() {
            return ImmutableSet.empty();
        }
    }

    public static class WellKnownAction<RequestType extends ActionRequest, RequestItem, RequestItemType>
    implements Action {
        private final String actionName;
        private final Scope scope;
        private final Class<RequestType> requestType;
        private final String requestTypeName;
        private final ImmutableList<AdditionalPrivileges<RequestType, RequestItem>> additionalPrivileges;
        private final RequestItems<RequestType, RequestItem, RequestItemType> requestItems;
        private final Resources resources;
        private final ImmutableSet<Action> asImmutableSet;
        private final Actions actions;
        private final int hashCode;
        private final ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling;
        private final Meta.Alias.ResolutionMode aliasResolutionMode;
        private final ImmutableSet<AdditionalDimension> additionalDimensions;
        private final boolean performanceCritical;

        public WellKnownAction(String actionName, Scope scope, Class<RequestType> requestType, String requestTypeName, ImmutableList<AdditionalPrivileges<RequestType, RequestItem>> additionalPrivileges, ImmutableMap<RequestItemType, ImmutableSet<String>> additionalPrivilegesByItemType, RequestItems<RequestType, RequestItem, RequestItemType> requestItems, Resources resources, ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling, Meta.Alias.ResolutionMode aliasResolutionMode, ImmutableSet<AdditionalDimension> additionalDimensions, boolean performanceCritical, Actions actions) {
            this.actionName = actionName;
            this.scope = scope;
            this.requestType = requestType;
            this.requestTypeName = requestTypeName;
            this.additionalPrivileges = additionalPrivileges;
            this.requestItems = requestItems;
            this.resources = resources;
            this.actions = actions;
            this.asImmutableSet = ImmutableSet.of((Object)this);
            this.hashCode = actionName.hashCode();
            this.aliasDataStreamHandling = aliasDataStreamHandling;
            this.aliasResolutionMode = aliasResolutionMode;
            this.additionalDimensions = additionalDimensions;
            this.performanceCritical = performanceCritical;
        }

        public String toString() {
            return this.actionName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WellKnownAction)) {
                return false;
            }
            WellKnownAction other = (WellKnownAction)obj;
            return other.hashCode == this.hashCode && other.actionName.equals(this.actionName);
        }

        @Override
        public String name() {
            return this.actionName;
        }

        @Override
        public boolean isIndexLikePrivilege() {
            return this.scope.canReferToIndexLikeObjects;
        }

        @Override
        public boolean isClusterPrivilege() {
            return this.scope == Scope.CLUSTER;
        }

        @Override
        public boolean isTenantPrivilege() {
            return this.scope == Scope.TENANT;
        }

        @Override
        public boolean isOpen() {
            return this.scope == Scope.OPEN;
        }

        @Override
        public boolean requiresSpecialProcessing() {
            return this.resources != null && (this.resources.createsResource != null || !this.resources.usesResources.isEmpty());
        }

        @Override
        public ImmutableSet<Action> getAdditionalPrivileges(ActionRequest request) {
            RequestType typedRequest = this.cast(request);
            ImmutableSet result = ImmutableSet.empty();
            for (AdditionalPrivileges additionalPrivilegeSpec : this.additionalPrivileges) {
                if (!additionalPrivilegeSpec.getCondition().test(typedRequest)) continue;
                result = result.with(additionalPrivilegeSpec.getPrivilegesAsActions(this.actions));
            }
            if (this.requestItems != null) {
                result = result.with(this.requestItems.evaluateItemTypePrivileges(typedRequest));
            }
            return result;
        }

        @Override
        public ImmutableSet<Action> expandPrivileges(ActionRequest request) {
            RequestType typedRequest = this.cast(request);
            ImmutableSet result = this.asImmutableSet;
            for (AdditionalPrivileges additionalPrivilegeSpec : this.additionalPrivileges) {
                if (!additionalPrivilegeSpec.getCondition().test(typedRequest)) continue;
                result = result.with(additionalPrivilegeSpec.getPrivilegesAsActions(this.actions));
            }
            if (this.requestItems != null) {
                result = result.with(this.requestItems.evaluateItemTypePrivileges(typedRequest));
            }
            return result;
        }

        public RequestType cast(ActionRequest request) {
            if (this.requestType != null) {
                return (RequestType)((ActionRequest)this.requestType.cast(request));
            }
            ActionRequest result = request;
            return (RequestType)result;
        }

        public Resources getResources() {
            return this.resources;
        }

        public String getRequestTypeName() {
            return this.requestTypeName;
        }

        @Override
        public ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling() {
            return this.aliasDataStreamHandling;
        }

        @Override
        public Meta.Alias.ResolutionMode aliasResolutionMode() {
            return this.aliasResolutionMode;
        }

        @Override
        public Scope scope() {
            return this.scope;
        }

        public <R extends ActionRequest> WellKnownAction<R, ?, ?> wellKnown(R request) {
            WellKnownAction result = this;
            result.cast(request);
            return result;
        }

        @Override
        public ImmutableSet<AdditionalDimension> additionalDimensions() {
            return this.additionalDimensions;
        }

        public boolean isPerformanceCritical() {
            return this.performanceCritical;
        }

        public static class RequestItems<RequestType extends ActionRequest, RequestItem, RequestItemType> {
            private final Function<RequestItem, RequestItemType> requestItemTypeFunction;
            private final Function<RequestType, Collection<RequestItem>> requestItemFunction;
            private final Map<RequestItemType, ImmutableSet<String>> additionalPrivilegesByItemType;
            private final Class<Enum<?>> requestItemTypeEnum;
            private final Actions actions;

            public RequestItems(Function<RequestItem, RequestItemType> requestItemTypeFunction, Function<RequestType, Collection<RequestItem>> requestItemFunction, Map<RequestItemType, ImmutableSet<String>> additionalPrivilegesByItemType, Class<Enum<?>> requestItemTypeEnum, Actions actions) {
                this.requestItemTypeFunction = requestItemTypeFunction;
                this.requestItemFunction = requestItemFunction;
                this.additionalPrivilegesByItemType = additionalPrivilegesByItemType;
                this.requestItemTypeEnum = requestItemTypeEnum;
                this.actions = actions;
            }

            Set<RequestItemType> createItemTypeSet() {
                if (this.requestItemTypeEnum != null) {
                    return EnumSet.noneOf(this.requestItemTypeEnum);
                }
                return new HashSet();
            }

            ImmutableSet<Action> evaluateItemTypePrivileges(RequestType request) {
                if (this.additionalPrivilegesByItemType == null || this.additionalPrivilegesByItemType.isEmpty()) {
                    return ImmutableSet.empty();
                }
                ImmutableSet result = ImmutableSet.empty();
                int itemTypeCount = this.additionalPrivilegesByItemType.size();
                Set<RequestItemType> seenItemTypes = null;
                if (itemTypeCount > 1) {
                    seenItemTypes = this.createItemTypeSet();
                }
                for (RequestItem requestItem : this.requestItemFunction.apply(request)) {
                    RequestItemType requestItemType = this.requestItemTypeFunction.apply(requestItem);
                    ImmutableSet<String> additionalPrivileges = this.additionalPrivilegesByItemType.get(requestItemType);
                    if (additionalPrivileges == null) continue;
                    result = result.with((Collection)additionalPrivileges.map(a -> this.actions.get((String)a)));
                    if (itemTypeCount == 1) break;
                    seenItemTypes.add(requestItemType);
                    if (seenItemTypes.size() != this.additionalPrivilegesByItemType.size()) continue;
                    break;
                }
                return result;
            }
        }

        public static class Resources {
            private final NewResource createsResource;
            private final ImmutableList<Resource> usesResources;

            public Resources(NewResource createsResource, List<Resource> usesResources) {
                this.createsResource = createsResource;
                this.usesResources = ImmutableList.of(usesResources);
            }

            public NewResource getCreatesResource() {
                return this.createsResource;
            }

            public ImmutableList<Resource> getUsesResources() {
                return this.usesResources;
            }
        }

        public static class NewResource {
            private final String type;
            private final Function<ActionResponse, Object> id;
            private final Function<ActionResponse, Instant> expiresAfter;

            public NewResource(String type, Function<ActionResponse, Object> id, Function<ActionResponse, Instant> expiresAfter) {
                this.type = type;
                this.id = id;
                this.expiresAfter = expiresAfter;
            }

            public String getType() {
                return this.type;
            }

            public Function<ActionResponse, Object> getId() {
                return this.id;
            }

            public Function<ActionResponse, Instant> getExpiresAfter() {
                return this.expiresAfter;
            }
        }

        public static class AdditionalPrivileges<RequestType extends ActionRequest, RequestItemType> {
            private final ImmutableSet<String> privileges;
            private final Predicate<RequestType> condition;
            private ImmutableSet<Action> privilegesAsActions;

            public AdditionalPrivileges(ImmutableSet<String> privileges, Predicate<RequestType> condition) {
                this.privileges = privileges;
                this.condition = condition;
            }

            public ImmutableSet<String> getPrivileges() {
                return this.privileges;
            }

            public ImmutableSet<Action> getPrivilegesAsActions(Actions actions) {
                ImmutableSet result = this.privilegesAsActions;
                if (result == null) {
                    this.privilegesAsActions = result = this.privileges.map(a -> actions.get((String)a));
                }
                return result;
            }

            public Predicate<RequestType> getCondition() {
                return this.condition;
            }
        }

        public static class RequestPropertyModifier<PropertyType> {
            private final Function<ActionRequest, PropertyType> attrGetter;
            private final BiFunction<ActionRequest, PropertyType, ?> attrSetter;
            private final Class<PropertyType> type;
            private final Function<PropertyType, PropertyType> function;

            public RequestPropertyModifier(Function<ActionRequest, PropertyType> attrGetter, BiFunction<ActionRequest, PropertyType, ?> attrSetter, Class<PropertyType> type, Function<PropertyType, PropertyType> function) {
                this.function = function;
                this.type = type;
                this.attrGetter = attrGetter;
                this.attrSetter = attrSetter;
            }

            public Class<PropertyType> getType() {
                return this.type;
            }

            public Function<PropertyType, PropertyType> getFunction() {
                return this.function;
            }

            public Function<ActionRequest, PropertyType> getAttrGetter() {
                return this.attrGetter;
            }

            public BiFunction<ActionRequest, PropertyType, ?> getAttrSetter() {
                return this.attrSetter;
            }

            public void apply(ActionRequest actionRequest) {
                PropertyType value = this.attrGetter.apply(actionRequest);
                PropertyType newValue = this.function.apply(value);
                this.attrSetter.apply(actionRequest, newValue);
            }
        }

        public static class Resource {
            private final String type;
            private final Function<ActionRequest, Object> id;
            private final boolean deleteAction;
            private final String ownerCheckBypassPermission;

            public Resource(String type, Function<ActionRequest, Object> id) {
                this(type, id, false, null);
            }

            public Resource(String type, Function<ActionRequest, Object> id, boolean deleteAction, String ownerCheckBypassPermission) {
                this.type = type;
                this.id = id;
                this.deleteAction = deleteAction;
                this.ownerCheckBypassPermission = ownerCheckBypassPermission;
            }

            public String getType() {
                return this.type;
            }

            public Function<ActionRequest, Object> getId() {
                return this.id;
            }

            public boolean isDeleteAction() {
                return this.deleteAction;
            }

            public Resource deleteAction(boolean deleteAction) {
                return new Resource(this.type, this.id, deleteAction, this.ownerCheckBypassPermission);
            }

            public Resource ownerCheckBypassPermission(String permission) {
                return new Resource(this.type, this.id, this.deleteAction, permission);
            }

            public String getOwnerCheckBypassPermission() {
                return this.ownerCheckBypassPermission;
            }
        }
    }

    public static enum Scope {
        INDEX_LIKE(true, true, true, false),
        INDEX(true, false, false, false),
        ALIAS(false, true, false, false),
        DATA_STREAM(false, false, true, false),
        CLUSTER(false, false, false, false),
        TENANT(false, false, false, true),
        OPEN(false, false, false, false);

        public final boolean canReferToIndices;
        public final boolean canReferToAliases;
        public final boolean canReferToDataStreams;
        public final boolean canReferToTenants;
        public final boolean canReferToIndexLikeObjects;
        public final boolean canOnlyReferToAliases;

        private Scope(boolean canReferToIndices, boolean canReferToAliases, boolean canReferToDataStreams, boolean canReferToTenants) {
            this.canReferToIndices = canReferToIndices;
            this.canReferToAliases = canReferToAliases;
            this.canReferToDataStreams = canReferToDataStreams;
            this.canReferToTenants = canReferToTenants;
            this.canReferToIndexLikeObjects = canReferToIndices || canReferToAliases || canReferToDataStreams;
            this.canOnlyReferToAliases = canReferToAliases && !canReferToDataStreams && !canReferToIndices;
        }
    }
}

