/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class ClusterInfoHolder
implements ClusterStateListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile DiscoveryNodes nodes = null;
    private volatile Boolean isLocalNodeElectedMaster = null;
    private volatile boolean initialized;

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.nodes == null || event.nodesChanged()) {
            this.nodes = event.state().nodes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder now initialized for 'nodes'");
            }
            this.initialized = true;
        }
        this.isLocalNodeElectedMaster = event.localNodeMaster() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isLocalNodeElectedMaster() {
        return this.isLocalNodeElectedMaster;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Boolean hasNode(DiscoveryNode node) {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.nodeExists(node) ? Boolean.TRUE : Boolean.FALSE;
    }
}

