/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.validation;

import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class ConfigModificationValidator<T> {
    private final CType<T> configType;
    private ConfigMap configMap;

    protected ConfigModificationValidator(CType<T> configType, ConfigurationRepository configurationRepository) {
        this.configType = Objects.requireNonNull(configType, "configType is required");
        Objects.requireNonNull(configurationRepository, "Configuration repository is required");
        configurationRepository.subscribeOnChange(this::setConfigMap);
    }

    public abstract List<ValidationError> validateConfigs(List<SgDynamicConfiguration<?>> var1);

    public abstract List<ValidationError> validateConfig(SgDynamicConfiguration<?> var1);

    public abstract <T> List<ValidationError> validateConfigEntry(T var1);

    public void setConfigMap(ConfigMap configMap) {
        this.configMap = configMap;
    }

    protected <T> Optional<SgDynamicConfiguration<T>> findCurrentConfiguration(CType<T> typeToLoad) {
        return Optional.ofNullable(this.configMap).map(confMap -> confMap.get(typeToLoad));
    }

    protected <T> Optional<SgDynamicConfiguration<T>> findConfigOfType(Class<T> type, List<SgDynamicConfiguration<?>> newConfigs) {
        return newConfigs.stream().filter(config -> config.getCType().getType().isAssignableFrom(type)).findFirst().map(config -> config);
    }

    protected ValidationError toValidationError(String configEntryKey, String message) {
        String attribute = Objects.nonNull(configEntryKey) ? String.format("%s.%s", this.configType.toLCString(), configEntryKey) : null;
        return new ValidationError(attribute, message);
    }
}

