/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.tasks.Task;

public class ExtendedActionFilterChain<Request extends ActionRequest, Response extends ActionResponse>
implements ActionFilterChain<Request, Response> {
    private final List<ActionFilter> additionalFilters;
    private final ActionFilterChain<Request, Response> originalChain;
    private final Iterator<ActionFilter> additionalFiltersIter;

    public ExtendedActionFilterChain(List<ActionFilter> additionalFilters, ActionFilterChain<Request, Response> originalChain) {
        this.additionalFilters = additionalFilters;
        this.additionalFiltersIter = additionalFilters.iterator();
        this.originalChain = originalChain;
    }

    public void proceed(Task task, String action, Request request, ActionListener<Response> listener) {
        if (this.additionalFiltersIter.hasNext()) {
            ActionFilter filter = this.additionalFiltersIter.next();
            filter.apply(task, action, request, listener, (ActionFilterChain)this);
        } else {
            this.originalChain.proceed(task, action, request, listener);
        }
    }

    public String toString() {
        return "ExtendedActionFilterChain [additionalFilters=" + String.valueOf(this.additionalFilters) + ", originalChain=" + String.valueOf(this.originalChain) + "]";
    }
}

