/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.jwt;

import com.floragunn.searchguard.jwt.NimbusUtils;
import com.floragunn.searchsupport.PrivilegedCode;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.proc.JWEDecrypterFactory;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.security.Key;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public class JwtVerifier {
    public static final String PRODUCER_CLAIM = "sg_p";
    public static final String PRODUCER_CLAIM_NIMBUS = "n";
    private static final JWEDecrypterFactory JWE_DECRYPTER_FACTORY = new DefaultJWEDecrypterFactory();
    private static final JWSVerifierFactory JWS_VERIFIER_FACTORY = new DefaultJWSVerifierFactory();
    private final JWK signingKey;
    private final JWK encryptionKey;
    private final JWTClaimsSetVerifier<SecurityContext> jwtClaimsVerifier;
    private final CxfBased cxfBased;

    public JwtVerifier(JWK signingKey, JWK encryptionKey, String requiredAudience) {
        this.signingKey = signingKey;
        this.encryptionKey = encryptionKey;
        this.jwtClaimsVerifier = new DefaultJWTClaimsVerifier(requiredAudience, null, null);
        this.cxfBased = new CxfBased(signingKey, encryptionKey, requiredAudience);
    }

    public JWT getVerfiedJwt(String encodedJwt) throws ParseException, JOSEException, BadJWTException {
        return this.getVerfiedJwt(encodedJwt, this.jwtClaimsVerifier, this.cxfBased);
    }

    public JWT getVerfiedJwt(String encodedJwt, String requiredAudience) throws ParseException, JOSEException, BadJWTException {
        return this.getVerfiedJwt(encodedJwt, (JWTClaimsSetVerifier<SecurityContext>)new DefaultJWTClaimsVerifier(requiredAudience, null, null), this.cxfBased.requiredAudience(requiredAudience));
    }

    private JWT getVerfiedJwt(String encodedJwt, JWTClaimsSetVerifier<SecurityContext> jwtClaimsVerifier, CxfBased cxfBased) throws ParseException, JOSEException, BadJWTException {
        SignedJWT signedJwt;
        boolean signatureValid;
        if (this.encryptionKey != null) {
            if (this.isJwtEncrypted(encodedJwt)) {
                JWEObject jweObject = JWEObject.parse((String)encodedJwt);
                if (jweObject.getHeader().getCustomParam(PRODUCER_CLAIM) == null) {
                    return cxfBased.getVerifiedJwt(encodedJwt);
                }
                jweObject.decrypt(this.decrypter(jweObject));
                encodedJwt = jweObject.getPayload().toSignedJWT().serialize();
            } else {
                return null;
            }
        }
        if (!(signatureValid = (signedJwt = SignedJWT.parse((String)encodedJwt)).verify(this.verifier(signedJwt)))) {
            throw new JOSEException("Invalid JWT signature");
        }
        jwtClaimsVerifier.verify(signedJwt.getJWTClaimsSet(), null);
        return signedJwt;
    }

    private boolean isJwtEncrypted(String jwt) {
        return jwt.split("\\.").length == 5;
    }

    JWEDecrypter decrypter(JWEObject jweObject) throws JOSEException {
        if (this.encryptionKey == null) {
            return null;
        }
        if (this.encryptionKey instanceof AsymmetricJWK) {
            return JWE_DECRYPTER_FACTORY.createJWEDecrypter(jweObject.getHeader(), (Key)((AsymmetricJWK)this.encryptionKey).toPrivateKey());
        }
        if (this.encryptionKey instanceof SecretJWK) {
            return JWE_DECRYPTER_FACTORY.createJWEDecrypter(jweObject.getHeader(), (Key)((SecretJWK)this.encryptionKey).toSecretKey());
        }
        throw new RuntimeException("Unknown key type: " + String.valueOf(this.encryptionKey));
    }

    JWSVerifier verifier(SignedJWT signedJWT) throws JOSEException {
        if (this.signingKey instanceof AsymmetricJWK) {
            return JWS_VERIFIER_FACTORY.createJWSVerifier(signedJWT.getHeader(), (Key)((AsymmetricJWK)this.signingKey).toPublicKey());
        }
        if (this.signingKey instanceof SecretJWK) {
            return JWS_VERIFIER_FACTORY.createJWSVerifier(signedJWT.getHeader(), (Key)((SecretJWK)this.signingKey).toSecretKey());
        }
        throw new RuntimeException("Unknown key type: " + String.valueOf(this.signingKey));
    }

    static class CxfBased {
        private final JwsSignatureVerifier jwsSignatureVerifier;
        private final JweDecryptionProvider jweDecryptionProvider;
        private final String requiredJwtAudience;

        CxfBased(JWK signingKey, JWK encryptionKey, String requiredJwtAudience) {
            this.requiredJwtAudience = requiredJwtAudience;
            this.jwsSignatureVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)NimbusUtils.convertToCxf(signingKey));
            this.jweDecryptionProvider = encryptionKey != null ? JweUtils.createJweDecryptionProvider((JsonWebKey)NimbusUtils.convertToCxf(encryptionKey), (ContentAlgorithm)ContentAlgorithm.A256CBC_HS512) : null;
        }

        private CxfBased(JwsSignatureVerifier jwsSignatureVerifier, JweDecryptionProvider jweDecryptionProvider, String requiredJwtAudience) {
            this.jwsSignatureVerifier = jwsSignatureVerifier;
            this.jweDecryptionProvider = jweDecryptionProvider;
            this.requiredJwtAudience = requiredJwtAudience;
        }

        CxfBased requiredAudience(String requiredAudience) {
            return new CxfBased(this.jwsSignatureVerifier, this.jweDecryptionProvider, requiredAudience);
        }

        JWT getVerifiedJwt(String encodedJwt) {
            boolean signatureValid;
            JwsJwtCompactConsumer jwtConsumer;
            JwtToken jwt;
            if (this.jweDecryptionProvider != null) {
                JweDecryptionOutput decOutput = this.jweDecryptionProvider.decrypt(encodedJwt);
                encodedJwt = decOutput.getContentText();
            }
            if (!this.validateAudience((jwt = (jwtConsumer = new JwsJwtCompactConsumer(encodedJwt)).getJwtToken()).getClaims())) {
                return null;
            }
            if (this.jwsSignatureVerifier != null && !(signatureValid = jwtConsumer.verifySignatureWith(this.jwsSignatureVerifier))) {
                throw new JwtException("Invalid JWT signature for token " + String.valueOf(jwt.getClaims().asMap()));
            }
            this.validateClaims(jwt);
            return (JWT)PrivilegedCode.execute(() -> new SignedJWT(CxfBased.cxfHeaderToNimbusHeader(jwt.getJwsHeaders()), CxfBased.cxfClaimsToNimbusClaims(jwt.getClaims())));
        }

        static JWSHeader cxfHeaderToNimbusHeader(JwsHeaders cxfHeaders) {
            JWSHeader.Builder nimbusBuilder = new JWSHeader.Builder(JWSAlgorithm.parse((String)cxfHeaders.getAlgorithm()));
            if (cxfHeaders.getType() != null) {
                nimbusBuilder.type(new JOSEObjectType(cxfHeaders.getType().toString()));
            }
            if (cxfHeaders.getContentType() != null) {
                nimbusBuilder.contentType(cxfHeaders.getContentType());
            }
            if (cxfHeaders.getCritical() != null) {
                nimbusBuilder.criticalParams(new HashSet(cxfHeaders.getCritical()));
            }
            if (cxfHeaders.getKeyId() != null) {
                nimbusBuilder.keyID(cxfHeaders.getKeyId());
            }
            for (Map.Entry entry : cxfHeaders.asMap().entrySet()) {
                if (JWSHeader.getRegisteredParameterNames().contains(entry.getKey())) continue;
                nimbusBuilder.customParam((String)entry.getKey(), entry.getValue());
            }
            return nimbusBuilder.build();
        }

        static JWTClaimsSet cxfClaimsToNimbusClaims(JwtClaims cxfClaimsSet) {
            JWTClaimsSet.Builder nimbusBuilder = new JWTClaimsSet.Builder();
            if (cxfClaimsSet.getIssuer() != null) {
                nimbusBuilder.issuer(cxfClaimsSet.getIssuer());
            }
            if (cxfClaimsSet.getSubject() != null) {
                nimbusBuilder.subject(cxfClaimsSet.getSubject());
            }
            if (cxfClaimsSet.getAudience() != null) {
                nimbusBuilder.audience(cxfClaimsSet.getAudience());
            }
            if (cxfClaimsSet.getExpiryTime() != null) {
                nimbusBuilder.expirationTime(Date.from(Instant.ofEpochMilli(cxfClaimsSet.getExpiryTime() * 1000L)));
            }
            if (cxfClaimsSet.getNotBefore() != null) {
                nimbusBuilder.notBeforeTime(Date.from(Instant.ofEpochMilli(cxfClaimsSet.getNotBefore() * 1000L)));
            }
            if (cxfClaimsSet.getIssuedAt() != null) {
                nimbusBuilder.issueTime(Date.from(Instant.ofEpochMilli(cxfClaimsSet.getIssuedAt() * 1000L)));
            }
            if (cxfClaimsSet.getTokenId() != null) {
                nimbusBuilder.jwtID(cxfClaimsSet.getTokenId());
            }
            Map customClaims = cxfClaimsSet.asMap();
            for (Map.Entry entry : customClaims.entrySet()) {
                if (JWTClaimsSet.getRegisteredNames().contains(entry.getKey())) continue;
                nimbusBuilder.claim((String)entry.getKey(), entry.getValue());
            }
            return nimbusBuilder.build();
        }

        private void validateClaims(JwtToken jwt) throws JwtException {
            JwtClaims claims = jwt.getClaims();
            if (claims == null) {
                throw new JwtException("The JWT does not have any claims");
            }
            JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)0, (boolean)false);
            JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)0, (boolean)false);
        }

        private boolean validateAudience(JwtClaims claims) throws JwtException {
            if (this.requiredJwtAudience != null) {
                for (String audience : claims.getAudiences()) {
                    if (!this.requiredJwtAudience.equals(audience)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

