/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class SSLReloadCertAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "_searchguard/api/ssl/{certType}/reloadcerts/"));
    private final SearchGuardKeyStore keyStore;
    private final ThreadContext threadContext;
    private final boolean sslCertReloadEnabled;
    private final AdminDNs adminDns;

    public SSLReloadCertAction(SearchGuardKeyStore keyStore, ThreadPool threadPool, AdminDNs adminDns, boolean sslCertReloadEnabled) {
        this.keyStore = keyStore;
        this.adminDns = adminDns;
        this.threadContext = threadPool.getThreadContext();
        this.sslCertReloadEnabled = sslCertReloadEnabled;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String certType;
            {
                this.certType = request.param("certType").toLowerCase().trim();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                RestResponse response;
                if (!SSLReloadCertAction.this.sslCertReloadEnabled) {
                    RestResponse response2 = new RestResponse(RestStatus.BAD_REQUEST, "SSL Reload action called while searchguard.ssl.cert_reload_enabled is set to false.");
                    channel.sendResponse(response2);
                    return;
                }
                XContentBuilder builder = channel.newBuilder();
                User user = (User)SSLReloadCertAction.this.threadContext.getTransient("_sg_user");
                if (user == null || !SSLReloadCertAction.this.adminDns.isAdmin(user)) {
                    response = new RestResponse(RestStatus.FORBIDDEN, "");
                } else {
                    try {
                        builder.startObject();
                        if (SSLReloadCertAction.this.keyStore != null) {
                            switch (this.certType) {
                                case "http": {
                                    SSLReloadCertAction.this.keyStore.initHttpSSLConfig();
                                    builder.field("message", "updated http certs");
                                    builder.endObject();
                                    response = new RestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                case "transport": {
                                    SSLReloadCertAction.this.keyStore.initTransportSSLConfig();
                                    builder.field("message", "updated transport certs");
                                    builder.endObject();
                                    response = new RestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                default: {
                                    builder.field("message", "invalid uri path, please use /_searchguard/api/ssl/http/reload or /_searchguard/api/ssl/transport/reload");
                                    builder.endObject();
                                    response = new RestResponse(RestStatus.FORBIDDEN, builder);
                                    break;
                                }
                            }
                        } else {
                            builder.field("message", "keystore is not initialized");
                            builder.endObject();
                            response = new RestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                        }
                    }
                    catch (Exception e1) {
                        builder = channel.newBuilder();
                        builder.startObject();
                        builder.field("error", e1.toString());
                        builder.endObject();
                        response = new RestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                    }
                }
                channel.sendResponse(response);
            }
        };
    }

    public String getName() {
        return "SSL Cert Reload Action";
    }
}

