/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.support.SourceFieldsContext;
import com.floragunn.searchguard.user.User;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;

public class Base64Helper {
    public static String serializeObject(Serializable object) {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            byte[] bytes = bos.toByteArray();
            return BaseEncoding.base64().encode(bytes);
        }
        catch (Exception e) {
            throw new ElasticsearchException(e.toString(), new Object[0]);
        }
    }

    public static Serializable deserializeObject(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        ObjectInputStream in = null;
        try {
            byte[] userr = BaseEncoding.base64().decode((CharSequence)string);
            ByteArrayInputStream bis = new ByteArrayInputStream(userr);
            in = new SafeObjectInputStream(bis);
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        catch (Exception e) {
            throw new ElasticsearchException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final class SafeObjectInputStream
    extends ObjectInputStream {
        private static final List<String> SAFE_CLASSES = new ArrayList<String>();

        public SafeObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = super.resolveClass(desc);
            if (clazz.isArray() || clazz.equals(String.class) || clazz.equals(SocketAddress.class) || clazz.equals(InetSocketAddress.class) || InetAddress.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || clazz.equals(User.class) || clazz.equals(SourceFieldsContext.class) || SAFE_CLASSES.contains(clazz.getName())) {
                return clazz;
            }
            throw new InvalidClassException("Unauthorized deserialization attempt", clazz.getName());
        }

        static {
            SAFE_CLASSES.add("com.floragunn.dlic.auth.ldap.LdapUser");
            SAFE_CLASSES.add("java.util.CollSer");
        }
    }
}

