/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.searchsupport.diag.LogContextPreservingActionListener;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class PrivilegedConfigClient
extends FilterClient {
    private PrivilegedConfigClient(Client in) {
        super(in);
    }

    public static PrivilegedConfigClient adapt(Client client) {
        if (client instanceof PrivilegedConfigClient) {
            return (PrivilegedConfigClient)client;
        }
        return new PrivilegedConfigClient(client);
    }

    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = this.threadPool().getThreadContext();
        LogContextPreservingActionListener wrappedListener = LogContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)threadContext);
        String actionStack = DiagnosticContext.getActionStack((ThreadContext)threadContext);
        Object user = threadContext.getTransient("_sg_user");
        Object remoteAddress = threadContext.getTransient("_sg_remote_address");
        Object origin = threadContext.getTransient("_sg_origin");
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            threadContext.putHeader("_sg_conf_request", "true");
            threadContext.putHeader("_sg_internal_auth_token", "");
            threadContext.putHeader("_sg_internal_auth_token_audience", "");
            if (user != null) {
                threadContext.putTransient("_sg_user", user);
            }
            if (remoteAddress != null) {
                threadContext.putTransient("_sg_remote_address", remoteAddress);
            }
            if (origin != null) {
                threadContext.putTransient("_sg_origin", origin);
            }
            if (actionStack != null) {
                threadContext.putHeader("x_action_stack", actionStack);
                DiagnosticContext.fixupLoggingContext((ThreadContext)threadContext);
            }
            super.doExecute(action, request, (ActionListener)wrappedListener);
        }
    }
}

