/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.license.LicenseChangeListener;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchsupport.StaticSettings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AuditLogConfig
implements LicenseChangeListener {
    public static final StaticSettings.Attribute<List<String>> COMPLIANCE_HISTORY_READ_WATCHED_FIELDS = StaticSettings.Attribute.define((String)"searchguard.compliance.history.read.watched_fields").asListOfStrings();
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings settings;
    private final Map<Pattern, Set<String>> readEnabledFields = new HashMap<Pattern, Set<String>>(100);
    private final List<String> watchedWriteIndices;
    private DateTimeFormatter auditLogPattern = null;
    private String auditLogIndex = null;
    private final boolean logDiffsForWrite;
    private final boolean logWriteMetadataOnly;
    private final boolean logReadMetadataOnly;
    private final boolean logInternalConfig;
    private final boolean logExternalConfig;
    private final LoadingCache<String, Set<String>> cache;
    private final Pattern searchguardIndexPattern;
    private volatile boolean enabled = true;

    public AuditLogConfig(Environment environment, ConfigurationRepository configRepository) {
        this.settings = environment.settings();
        this.searchguardIndexPattern = configRepository.getConfiguredSearchguardIndices();
        List watchedReadFields = this.settings.getAsList("searchguard.compliance.history.read.watched_fields", Collections.emptyList(), Boolean.valueOf(false));
        this.watchedWriteIndices = this.settings.getAsList("searchguard.compliance.history.write.watched_indices", Collections.emptyList());
        this.logDiffsForWrite = this.settings.getAsBoolean("searchguard.compliance.history.write.log_diffs", Boolean.valueOf(false));
        this.logWriteMetadataOnly = this.settings.getAsBoolean("searchguard.compliance.history.write.metadata_only", Boolean.valueOf(false));
        this.logReadMetadataOnly = this.settings.getAsBoolean("searchguard.compliance.history.read.metadata_only", Boolean.valueOf(false));
        this.logExternalConfig = this.settings.getAsBoolean("searchguard.compliance.history.external_config_enabled", Boolean.valueOf(false));
        this.logInternalConfig = this.settings.getAsBoolean("searchguard.compliance.history.internal_config_enabled", Boolean.valueOf(false));
        for (String watchedReadField : watchedReadFields) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(watchedReadField.split(",")));
            try {
                if (split.isEmpty()) continue;
                if (split.size() == 1) {
                    this.readEnabledFields.put(Pattern.create((String)((String)split.get(0))), Collections.singleton("*"));
                    continue;
                }
                HashSet _fields = new HashSet(split.subList(1, split.size()));
                this.readEnabledFields.put(Pattern.create((String)((String)split.get(0))), _fields);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Invalid index pattern in searchguard.compliance.history.read.watched_fields", e);
            }
        }
        String type = this.settings.get("searchguard.audit.type", null);
        if ("internal_elasticsearch".equalsIgnoreCase(type)) {
            String index = this.settings.get("searchguard.audit.config.index", "'sg6-auditlog-'YYYY.MM.dd");
            try {
                this.auditLogPattern = DateTimeFormat.forPattern((String)index);
            }
            catch (IllegalArgumentException e) {
                this.auditLogIndex = index;
            }
            catch (Exception e) {
                this.log.error("Unable to check if auditlog index {} is part of compliance setup", (Object)index, (Object)e);
            }
        }
        this.log.info("PII configuration [auditLogPattern={},  auditLogIndex={}]: {}", (Object)this.auditLogPattern, (Object)this.auditLogIndex, this.readEnabledFields);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Set<String>>(){

            public Set<String> load(String index) throws Exception {
                return AuditLogConfig.this.getFieldsForIndex0(index);
            }
        });
    }

    public void onChange(SearchGuardLicense license) {
        this.enabled = license == null ? false : license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE);
        this.log.info("Compliance features are " + (this.enabled ? "enabled" : "disabled. To enable them you need a special license. Please contact support for this."));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Set<String> getFieldsForIndex0(String index) {
        if (index == null) {
            return Collections.EMPTY_SET;
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return Collections.EMPTY_SET;
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> tmp = new HashSet<String>(100);
        for (Pattern indexPattern : this.readEnabledFields.keySet()) {
            if (!indexPattern.matches(index)) continue;
            tmp.addAll((Collection<String>)this.readEnabledFields.get(indexPattern));
        }
        return tmp;
    }

    private String getExpandedIndexName(DateTimeFormatter indexPattern, String index) {
        if (indexPattern == null) {
            return index;
        }
        return indexPattern.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    public boolean writeHistoryEnabledForIndex(String index) {
        if (index == null) {
            return false;
        }
        if (this.searchguardIndexPattern.matches(index)) {
            return this.logInternalConfig;
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return false;
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return false;
        }
        return WildcardMatcher.matchAny(this.watchedWriteIndices, (String)index);
    }

    public boolean readHistoryEnabledForIndex(String index) {
        if (!this.enabled) {
            return false;
        }
        if (this.searchguardIndexPattern.matches(index)) {
            return this.logInternalConfig;
        }
        try {
            return !((Set)this.cache.get((Object)index)).isEmpty();
        }
        catch (ExecutionException e) {
            this.log.error((Object)e);
            return true;
        }
    }

    public boolean readHistoryEnabledForField(String index, String field) {
        if (!this.enabled) {
            return false;
        }
        if (this.searchguardIndexPattern.matches(index)) {
            return this.logInternalConfig;
        }
        try {
            Set fields = (Set)this.cache.get((Object)index);
            if (fields.isEmpty()) {
                return false;
            }
            return WildcardMatcher.matchAny((Collection)fields, (String)field);
        }
        catch (ExecutionException e) {
            this.log.error((Object)e);
            return true;
        }
    }

    public boolean logDiffsForWrite() {
        return !this.logWriteMetadataOnly() && this.logDiffsForWrite;
    }

    public boolean logWriteMetadataOnly() {
        return this.logWriteMetadataOnly;
    }

    public boolean logReadMetadataOnly() {
        return this.logReadMetadataOnly;
    }

    public boolean isLogExternalConfig() {
        return this.logExternalConfig;
    }
}

