/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.google.common.cache.Cache;

public abstract class CacheStats
extends Measurement<CacheStats> {
    static final String TYPE = "cache";

    public abstract int getCurrentSize();

    public abstract long getHitCount();

    public abstract long getMissCount();

    public abstract long getEvictionCount();

    @Override
    public CacheStats clone() {
        Static result = new Static();
        result.currentSize = this.getCurrentSize();
        result.hitCount = this.getHitCount();
        result.missCount = this.getMissCount();
        result.evictionCount = this.getEvictionCount();
        return result;
    }

    public static CacheStats from(Cache<?, ?> cache) {
        return new Live(cache);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    static class Static
    extends CacheStats {
        private int currentSize;
        private long hitCount;
        private long missCount;
        private long evictionCount;

        public Static() {
        }

        Static(DocNode docNode) throws ConfigValidationException {
            this.currentSize = docNode.getNumber("current_size") != null ? docNode.getNumber("current_size").intValue() : 0;
            this.hitCount = docNode.getNumber("hit_count") != null ? docNode.getNumber("hit_count").longValue() : 0L;
            this.missCount = docNode.getNumber("miss_count") != null ? docNode.getNumber("miss_count").longValue() : 0L;
            this.evictionCount = docNode.getNumber("eviction_count") != null ? docNode.getNumber("eviction_count").longValue() : 0L;
        }

        @Override
        public int getCurrentSize() {
            return this.currentSize;
        }

        public void setCurrentSize(int currentSize) {
            this.currentSize = currentSize;
        }

        @Override
        public long getHitCount() {
            return this.hitCount;
        }

        public void setHitCount(long hitCount) {
            this.hitCount = hitCount;
        }

        @Override
        public long getMissCount() {
            return this.missCount;
        }

        public void setMissCount(long missCount) {
            this.missCount = missCount;
        }

        @Override
        public long getEvictionCount() {
            return this.evictionCount;
        }

        public void setEvictionCount(long evictionCount) {
            this.evictionCount = evictionCount;
        }

        @Override
        public CacheStats clone() {
            Static result = new Static();
            result.currentSize = this.currentSize;
            result.hitCount = this.hitCount;
            result.missCount = this.missCount;
            result.evictionCount = this.evictionCount;
            return result;
        }

        public static CacheStats copyFrom(Cache<?, ?> cache) {
            Static result = new Static();
            result.currentSize = (int)cache.size();
            com.google.common.cache.CacheStats cacheStats = cache.stats();
            result.hitCount = cacheStats.hitCount();
            result.missCount = cacheStats.loadCount();
            result.evictionCount = cacheStats.evictionCount();
            return result;
        }

        @Override
        public void addToThis(CacheStats other) {
            this.currentSize += other.getCurrentSize();
            this.hitCount += other.getHitCount();
            this.missCount += other.getMissCount();
            this.evictionCount += other.getEvictionCount();
        }

        @Override
        public void addToThis(Measurement<?> other) {
            if (other instanceof CacheStats) {
                this.addToThis((CacheStats)other);
            }
        }

        public Object toBasicObject() {
            return OrderedImmutableMap.of((Object)"current_size", (Object)this.currentSize, (Object)"hit_count", (Object)this.hitCount, (Object)"miss_count", (Object)this.missCount, (Object)"eviction_count", (Object)this.evictionCount);
        }

        @Override
        public void reset() {
        }
    }

    static class Live
    extends CacheStats {
        private final Cache<?, ?> cache;

        Live(Cache<?, ?> cache) {
            this.cache = cache;
        }

        public Object toBasicObject() {
            com.google.common.cache.CacheStats cacheStats = this.cache.stats();
            return OrderedImmutableMap.of((Object)"current_size", (Object)this.cache.size(), (Object)"hit_count", (Object)cacheStats.hitCount(), (Object)"miss_count", (Object)cacheStats.missCount(), (Object)"eviction_count", (Object)cacheStats.evictionCount());
        }

        @Override
        public int getCurrentSize() {
            return (int)this.cache.size();
        }

        @Override
        public long getHitCount() {
            return this.cache.stats().hitCount();
        }

        @Override
        public long getMissCount() {
            return this.cache.stats().missCount();
        }

        @Override
        public long getEvictionCount() {
            return this.cache.stats().evictionCount();
        }

        @Override
        public void addToThis(CacheStats other) {
        }

        @Override
        public void addToThis(Measurement<?> other) {
        }

        @Override
        public CacheStats clone() {
            Static result = new Static();
            result.currentSize = (int)this.cache.size();
            com.google.common.cache.CacheStats cacheStats = this.cache.stats();
            result.hitCount = cacheStats.hitCount();
            result.missCount = cacheStats.loadCount();
            result.evictionCount = cacheStats.evictionCount();
            return result;
        }

        @Override
        public void reset() {
        }
    }
}

