/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.queries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;

public class DateMathExpressionResolver {
    private static final DateFormatter DEFAULT_DATE_FORMATTER = DateFormatter.forPattern((String)"uuuu.MM.dd");
    private static final String EXPRESSION_LEFT_BOUND = "<";
    private static final String EXPRESSION_RIGHT_BOUND = ">";
    private static final char LEFT_BOUND = '{';
    private static final char RIGHT_BOUND = '}';
    private static final char ESCAPE_CHAR = '\\';
    private static final char TIME_ZONE_BOUND = '|';

    public static String resolveExpression(String expression) {
        if (!expression.startsWith(EXPRESSION_LEFT_BOUND) || !expression.endsWith(EXPRESSION_RIGHT_BOUND)) {
            return expression;
        }
        boolean escape = false;
        boolean inDateFormat = false;
        boolean inPlaceHolder = false;
        StringBuilder beforePlaceHolderSb = new StringBuilder();
        StringBuilder inPlaceHolderSb = new StringBuilder();
        char[] text = expression.toCharArray();
        boolean from = true;
        int length = text.length - 1;
        block8: for (int i = 1; i < length; ++i) {
            char c;
            boolean escapedChar = escape;
            if (escape) {
                escape = false;
            }
            if ((c = text[i]) == '\\') {
                if (escapedChar) {
                    beforePlaceHolderSb.append(c);
                    escape = false;
                    continue;
                }
                escape = true;
                continue;
            }
            if (inPlaceHolder) {
                switch (c) {
                    case '{': {
                        if (inDateFormat && escapedChar) {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                        if (!inDateFormat) {
                            inDateFormat = true;
                            inPlaceHolderSb.append(c);
                            break;
                        }
                        throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character in placeholder at position [{}]", new Object[]{new String(text, 1, length), i});
                    }
                    case '}': {
                        ZoneId timeZone;
                        DateFormatter dateFormatter;
                        String mathExpression;
                        if (inDateFormat && escapedChar) {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                        if (inDateFormat) {
                            inDateFormat = false;
                            inPlaceHolderSb.append(c);
                            break;
                        }
                        String inPlaceHolderString = inPlaceHolderSb.toString();
                        int dateTimeFormatLeftBoundIndex = inPlaceHolderString.indexOf(123);
                        if (dateTimeFormatLeftBoundIndex < 0) {
                            mathExpression = inPlaceHolderString;
                            dateFormatter = DEFAULT_DATE_FORMATTER;
                            timeZone = ZoneOffset.UTC;
                        } else {
                            String dateFormatterPattern;
                            if (inPlaceHolderString.lastIndexOf(125) != inPlaceHolderString.length() - 1) {
                                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing closing `}` for date math format", new Object[]{inPlaceHolderString});
                            }
                            if (dateTimeFormatLeftBoundIndex == inPlaceHolderString.length() - 2) {
                                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing date format", new Object[]{inPlaceHolderString});
                            }
                            mathExpression = inPlaceHolderString.substring(0, dateTimeFormatLeftBoundIndex);
                            String patternAndTZid = inPlaceHolderString.substring(dateTimeFormatLeftBoundIndex + 1, inPlaceHolderString.length() - 1);
                            int formatPatternTimeZoneSeparatorIndex = patternAndTZid.indexOf(124);
                            if (formatPatternTimeZoneSeparatorIndex != -1) {
                                dateFormatterPattern = patternAndTZid.substring(0, formatPatternTimeZoneSeparatorIndex);
                                timeZone = DateUtils.of((String)patternAndTZid.substring(formatPatternTimeZoneSeparatorIndex + 1));
                            } else {
                                dateFormatterPattern = patternAndTZid;
                                timeZone = ZoneOffset.UTC;
                            }
                            dateFormatter = DateFormatter.forPattern((String)dateFormatterPattern);
                        }
                        DateFormatter formatter = dateFormatter.withZone(timeZone);
                        DateMathParser dateMathParser = formatter.toDateMathParser();
                        Instant instant = dateMathParser.parse(mathExpression, () -> System.currentTimeMillis(), false, timeZone);
                        String time = formatter.format((TemporalAccessor)instant);
                        beforePlaceHolderSb.append(time);
                        inPlaceHolderSb = new StringBuilder();
                        inPlaceHolder = false;
                        break;
                    }
                    default: {
                        inPlaceHolderSb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '{': {
                    if (escapedChar) {
                        beforePlaceHolderSb.append(c);
                        continue block8;
                    }
                    inPlaceHolder = true;
                    continue block8;
                }
                case '}': {
                    if (!escapedChar) {
                        throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character at position [{}]. `{` and `}` are reserved characters and should be escaped when used as part of the index name using `\\` (e.g. `\\{text\\}`)", new Object[]{new String(text, 1, length), i});
                    }
                }
                default: {
                    beforePlaceHolderSb.append(c);
                }
            }
        }
        if (inPlaceHolder) {
            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. date math placeholder is open ended", new Object[]{new String(text, 1, length)});
        }
        if (beforePlaceHolderSb.length() == 0) {
            throw new ElasticsearchParseException("nothing captured", new Object[0]);
        }
        return beforePlaceHolderSb.toString();
    }
}

