/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authtoken.AuthToken;
import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class CreateAuthTokenResponse
extends ActionResponse
implements ToXContentObject {
    private AuthToken authToken;
    private String jwt;

    public CreateAuthTokenResponse() {
    }

    public CreateAuthTokenResponse(AuthToken authToken, String jwt) {
        this.authToken = authToken;
        this.jwt = jwt;
    }

    public CreateAuthTokenResponse(StreamInput in) throws IOException {
        super(in);
        this.authToken = new AuthToken(in);
        this.jwt = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.authToken.writeTo(out);
        out.writeString(this.jwt);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("token", this.jwt);
        builder.field("id", this.authToken.getId());
        this.authToken.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public String getJwt() {
        return this.jwt;
    }
}

