/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authtoken.AuthToken;
import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetAuthTokenResponse
extends ActionResponse
implements ToXContentObject {
    private AuthToken authToken;
    private RestStatus restStatus;
    private String error;

    public GetAuthTokenResponse() {
    }

    public GetAuthTokenResponse(AuthToken authToken) {
        this.authToken = authToken;
        this.restStatus = RestStatus.OK;
    }

    public GetAuthTokenResponse(RestStatus restStatus, String error) {
        this.restStatus = restStatus;
        this.error = error;
    }

    public GetAuthTokenResponse(StreamInput in) throws IOException {
        super(in);
        this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
        this.error = in.readOptionalString();
        if (in.readBoolean()) {
            this.authToken = new AuthToken(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.restStatus);
        out.writeOptionalString(this.error);
        out.writeBoolean(this.authToken != null);
        if (this.authToken != null) {
            this.authToken.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.authToken != null) {
            this.authToken.toXContent(builder, params);
        } else {
            builder.startObject();
            if (this.restStatus != null) {
                builder.field("status", this.restStatus.getStatus());
            }
            if (this.error != null) {
                builder.field("error", this.error);
            }
            builder.endObject();
        }
        return builder;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public RestStatus status() {
        return this.restStatus;
    }
}

