/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class RestApiPrivilegesEvaluator {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final AdminDNs adminDNs;
    private final AuthorizationService authorizationService;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;
    private final PrincipalExtractor principalExtractor;
    private final Path configPath;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final Set<String> allowedRoles = new HashSet<String>();
    private final Map<String, Map<Endpoint, List<RestRequest.Method>>> disabledEndpointsForRoles = new HashMap<String, Map<Endpoint, List<RestRequest.Method>>>();
    private final Map<String, Map<Endpoint, List<RestRequest.Method>>> disabledEndpointsForUsers = new HashMap<String, Map<Endpoint, List<RestRequest.Method>>>();
    Map<Endpoint, List<RestRequest.Method>> globallyDisabledEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
    Map<Endpoint, List<RestRequest.Method>> allEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
    private final Boolean roleBasedAccessEnabled;

    public RestApiPrivilegesEvaluator(Settings settings, AdminDNs adminDNs, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, PrincipalExtractor principalExtractor, Path configPath, ThreadPool threadPool) {
        this.adminDNs = adminDNs;
        this.authorizationService = authorizationService;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
        this.threadPool = threadPool;
        this.settings = settings;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
        HashMap allEndpoints = new HashMap();
        for (Endpoint endpoint : Endpoint.values()) {
            LinkedList<RestRequest.Method> allMethods = new LinkedList<RestRequest.Method>();
            allMethods.addAll(Arrays.asList(RestRequest.Method.values()));
            allEndpoints.put(endpoint, allMethods);
        }
        this.allEndpoints = Collections.unmodifiableMap(allEndpoints);
        this.allowedRoles.addAll(settings.getAsList("searchguard.restapi.roles_enabled"));
        this.roleBasedAccessEnabled = !this.allowedRoles.isEmpty();
        Settings globalSettings = settings.getAsSettings("searchguard.restapi.endpoints_disabled.global");
        if (!globalSettings.isEmpty()) {
            this.globallyDisabledEndpoints = this.parseDisabledEndpoints(globalSettings);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Globally disabled endpoints: {}", this.globallyDisabledEndpoints);
        }
        for (String role : this.allowedRoles) {
            Settings settingsForRole = settings.getAsSettings("searchguard.restapi.endpoints_disabled." + role);
            if (settingsForRole.isEmpty()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("No disabled endpoints/methods for permitted role {} found, allowing all", (Object)role);
                continue;
            }
            Map<Endpoint, List<RestRequest.Method>> disabledEndpointsForRole = this.parseDisabledEndpoints(settingsForRole);
            if (!disabledEndpointsForRole.isEmpty()) {
                this.disabledEndpointsForRoles.put(role, disabledEndpointsForRole);
                continue;
            }
            this.logger.warn("Disabled endpoints/methods empty for role {}, please check configuration", (Object)role);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Parsed permission set for endpoints: {}", this.disabledEndpointsForRoles);
        }
    }

    private Map<Endpoint, List<RestRequest.Method>> parseDisabledEndpoints(Settings settings) {
        if (settings == null || settings.isEmpty()) {
            this.logger.error("Settings for disabled endpoint is null or empty: '{}', skipping.", (Object)settings);
            return Collections.emptyMap();
        }
        HashMap<Endpoint, List<RestRequest.Method>> disabledEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
        Map<String, Object> disabledEndpointsSettings = RestApiPrivilegesEvaluator.convertJsonToxToStructuredMap((ToXContent)settings);
        for (Map.Entry<String, Object> value : disabledEndpointsSettings.entrySet()) {
            String endpointString = value.getKey().toUpperCase();
            Endpoint endpoint = null;
            try {
                endpoint = Endpoint.valueOf(endpointString);
            }
            catch (Exception e) {
                this.logger.error("Unknown endpoint '{}' found in configuration, skipping.", (Object)endpointString);
                continue;
            }
            if (value.getValue() == null) {
                this.logger.error("Disabled HTTP methods of endpoint '{}' is null, skipping.", (Object)endpointString);
                continue;
            }
            if (!(value.getValue() instanceof Collection)) {
                this.logger.error("Disabled HTTP methods of endpoint '{}' must be an array, actually is '{}', skipping.", (Object)endpointString, (Object)value.getValue().toString());
            }
            LinkedList<RestRequest.Method> disabledMethods = new LinkedList<RestRequest.Method>();
            for (Object disabledMethodObj : (Collection)value.getValue()) {
                if (disabledMethodObj == null) {
                    this.logger.error("Found null value in disabled HTTP methods of endpoint '{}', skipping.", (Object)endpointString);
                    continue;
                }
                if (!(disabledMethodObj instanceof String)) {
                    this.logger.error("Found non-String value in disabled HTTP methods of endpoint '{}', skipping.", (Object)endpointString);
                    continue;
                }
                String disabledMethodAsString = (String)disabledMethodObj;
                if (disabledMethodAsString.trim().equals("*")) {
                    disabledMethods.addAll(Arrays.asList(RestRequest.Method.values()));
                    break;
                }
                RestRequest.Method disabledMethod = null;
                try {
                    disabledMethod = RestRequest.Method.valueOf((String)disabledMethodAsString.toUpperCase());
                }
                catch (Exception e) {
                    this.logger.error("Invalid HTTP method '{}' found in disabled HTTP methods of endpoint '{}', skipping.", (Object)disabledMethodAsString.toUpperCase(), (Object)endpointString);
                    continue;
                }
                disabledMethods.add(disabledMethod);
            }
            disabledEndpoints.put(endpoint, disabledMethods);
        }
        return disabledEndpoints;
    }

    private static Map<String, Object> convertJsonToxToStructuredMap(ToXContent jsonContent) {
        Map map = null;
        try {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (boolean)false);
            map = (Map)XContentHelper.convertToMap((BytesReference)bytes, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
        return map;
    }

    public String checkAccessPermissions(RestRequest request, Endpoint endpoint) throws IOException {
        String roleBasedAccessFailureReason;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking admin access for endpoint {}, path {} and method {}", (Object)endpoint.name(), (Object)request.path(), (Object)request.method().name());
        }
        if ((roleBasedAccessFailureReason = this.checkRoleBasedAccessPermissions(request, endpoint)) == null) {
            return null;
        }
        String certBasedAccessFailureReason = this.checkAdminCertBasedAccessPermissions(request);
        if (certBasedAccessFailureReason == null) {
            return null;
        }
        return this.constructAccessErrorMessage(roleBasedAccessFailureReason, certBasedAccessFailureReason);
    }

    public boolean currentUserHasRestApiAccess(Set<String> userRoles) {
        return !Collections.disjoint(this.allowedRoles, userRoles);
    }

    public Map<Endpoint, List<RestRequest.Method>> getDisabledEndpointsForCurrentUser(User user, Set<String> userRoles) {
        String userPrincipal = user.getName();
        if (this.disabledEndpointsForUsers.containsKey(userPrincipal)) {
            return this.disabledEndpointsForUsers.get(userPrincipal);
        }
        if (!this.currentUserHasRestApiAccess(userRoles)) {
            return this.allEndpoints;
        }
        HashMap<Endpoint, List<RestRequest.Method>> finalEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
        LinkedList<Endpoint> remainingEndpoints = new LinkedList<Endpoint>(Arrays.asList(Endpoint.values()));
        boolean hasDisabledEndpoints = false;
        for (String userRole : userRoles) {
            Map<Endpoint, List<RestRequest.Method>> endpointsForRole = this.disabledEndpointsForRoles.get(userRole);
            if (endpointsForRole == null || endpointsForRole.isEmpty()) continue;
            Set<Endpoint> disabledEndpoints = endpointsForRole.keySet();
            remainingEndpoints.retainAll(disabledEndpoints);
            hasDisabledEndpoints = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Remaining endpoints for user {} after retaining all : {}", (Object)userPrincipal, remainingEndpoints);
        }
        if (!hasDisabledEndpoints) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No disabled endpoints for user {} at all,  only globally disabledendpoints apply.", (Object)userPrincipal, remainingEndpoints);
            }
            this.disabledEndpointsForUsers.put(userPrincipal, this.addGloballyDisabledEndpoints(finalEndpoints));
            return finalEndpoints;
        }
        for (Endpoint endpoint : remainingEndpoints) {
            LinkedList<RestRequest.Method> remainingMethodsForEndpoint = new LinkedList<RestRequest.Method>(Arrays.asList(RestRequest.Method.values()));
            for (String userRole : userRoles) {
                Map<Endpoint, List<RestRequest.Method>> endpoints = this.disabledEndpointsForRoles.get(userRole);
                if (endpoints == null || endpoints.isEmpty()) continue;
                remainingMethodsForEndpoint.retainAll((Collection)endpoints.get((Object)endpoint));
            }
            finalEndpoints.put(endpoint, remainingMethodsForEndpoint);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disabled endpoints for user {} after retaining all : {}", (Object)userPrincipal, finalEndpoints);
        }
        this.addGloballyDisabledEndpoints(finalEndpoints);
        this.disabledEndpointsForUsers.put(userPrincipal, finalEndpoints);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disabled endpoints for user {} after retaining all : {}", this.disabledEndpointsForUsers.get(userPrincipal));
        }
        return this.disabledEndpointsForUsers.get(userPrincipal);
    }

    private Map<Endpoint, List<RestRequest.Method>> addGloballyDisabledEndpoints(Map<Endpoint, List<RestRequest.Method>> endpoints) {
        if (this.globallyDisabledEndpoints != null && !this.globallyDisabledEndpoints.isEmpty()) {
            Set<Endpoint> globalEndoints = this.globallyDisabledEndpoints.keySet();
            for (Endpoint endpoint : globalEndoints) {
                endpoints.putIfAbsent(endpoint, new LinkedList());
                endpoints.get((Object)endpoint).addAll((Collection<RestRequest.Method>)this.globallyDisabledEndpoints.get((Object)endpoint));
            }
        }
        return endpoints;
    }

    private String checkRoleBasedAccessPermissions(RestRequest request, Endpoint endpoint) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Checking role based admin access for endpoint {} and method {}", (Object)endpoint.name(), (Object)request.method().name());
        }
        if (this.roleBasedAccessEnabled.booleanValue()) {
            ImmutableSet userRoles;
            User user = (User)this.threadPool.getThreadContext().getTransient("_sg_user");
            SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = null;
            if (this.specialPrivilegesEvaluationContextProviderRegistry != null) {
                specialPrivilegesEvaluationContext = this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, this.threadPool.getThreadContext());
            }
            if (specialPrivilegesEvaluationContext == null) {
                TransportAddress remoteAddress = (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
                userRoles = this.authorizationService.getMappedRoles(user, remoteAddress);
            } else {
                user = specialPrivilegesEvaluationContext.getUser();
                TransportAddress remoteAddress = specialPrivilegesEvaluationContext.getCaller() != null ? specialPrivilegesEvaluationContext.getCaller() : (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
                userRoles = specialPrivilegesEvaluationContext.getMappedRoles();
                if (!specialPrivilegesEvaluationContext.isSgConfigRestApiAllowed()) {
                    this.logger.info("User {} is authenticated with auth token which does not allow REST API access.", (Object)user, (Object)userRoles);
                    return "User " + user.getName() + " is authenticated with auth token which does not allow REST API access.";
                }
            }
            if (this.currentUserHasRestApiAccess((Set<String>)userRoles)) {
                List<RestRequest.Method> disabledMethodsForEndpoint;
                Map<Endpoint, List<RestRequest.Method>> disabledEndpointsForUser = this.getDisabledEndpointsForCurrentUser(user, (Set<String>)userRoles);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Disabled endpoints for user {} : {} ", (Object)user, disabledEndpointsForUser);
                }
                if ((disabledMethodsForEndpoint = disabledEndpointsForUser.get((Object)endpoint)) == null || disabledMethodsForEndpoint.isEmpty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("No disabled methods for user {} and endpoint {}, access allowed ", (Object)user, (Object)endpoint);
                    }
                    return null;
                }
                if (!disabledMethodsForEndpoint.contains(request.method())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Request method {} for user {} and endpoint {} not restricted, access allowed ", (Object)request.method(), (Object)user, (Object)endpoint);
                    }
                    return null;
                }
                this.logger.info("User {} with Search Guard Roles {} does not have access to endpoint {} and method {}, checking admin TLS certificate now.", (Object)user, (Object)userRoles, (Object)endpoint.name(), (Object)request.method());
                return "User " + user.getName() + " with Search Guard Roles " + String.valueOf(userRoles) + " does not have any access to endpoint " + endpoint.name() + " and method " + request.method().name();
            }
            this.logger.info("User {} with Search Guard roles {} does not have any role privileged for admin access.", (Object)user, (Object)userRoles);
            return "User " + user.getName() + " with Search Guard Roles " + String.valueOf(userRoles) + " does not have any role privileged for admin access";
        }
        return "Role based access not enabled.";
    }

    private String checkAdminCertBasedAccessPermissions(RestRequest request) throws IOException {
        SSLRequestHelper.SSLInfo sslInfo;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Checking certificate based admin access for path {} and method {}", (Object)request.path(), (Object)request.method().name());
        }
        if ((sslInfo = SSLRequestHelper.getSSLInfo((Settings)this.settings, (Path)this.configPath, (RestRequest)request, (PrincipalExtractor)this.principalExtractor)) == null) {
            this.logger.warn("No ssl info found in request.");
            return "No ssl info found in request.";
        }
        X509Certificate[] certs = sslInfo.getX509Certs();
        if (certs == null || certs.length == 0) {
            this.logger.warn("No client TLS certificate found in request");
            return "No client TLS certificate found in request";
        }
        if (!this.adminDNs.isAdminDN(sslInfo.getPrincipal())) {
            this.logger.warn("SG admin permissions required but {} is not an admin", (Object)sslInfo.getPrincipal());
            return "SG admin permissions required but " + sslInfo.getPrincipal() + " is not an admin";
        }
        return null;
    }

    private String constructAccessErrorMessage(String roleBasedAccessFailure, String certBasedAccessFailure) {
        return roleBasedAccessFailure + ". " + certBasedAccessFailure;
    }
}

